/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.ArtifactParams;
import com.nordstrom.automation.junit.ArtifactType;
import com.nordstrom.common.file.PathUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ArtifactCollector<T extends ArtifactType>
extends TestWatcher {
    private static final Map<Description, List<ArtifactCollector<? extends ArtifactType>>> watcherMap = new ConcurrentHashMap<Description, List<ArtifactCollector<? extends ArtifactType>>>();
    private final T provider;
    private final Object instance;
    private Description description;
    private final List<Path> artifactPaths = new ArrayList<Path>();

    public ArtifactCollector(Object instance, T provider) {
        this.instance = instance;
        this.provider = provider;
    }

    public void starting(Description description) {
        this.description = description;
        List<ArtifactCollector<? extends ArtifactType>> watcherList = watcherMap.get(description);
        if (watcherList == null) {
            watcherList = new ArrayList<ArtifactCollector<? extends ArtifactType>>();
            watcherMap.put(description, watcherList);
        }
        watcherList.add(this);
    }

    public void failed(Throwable e, Description description) {
        this.captureArtifact(e);
    }

    public Optional<Path> captureArtifact(Throwable reason) {
        Path artifactPath;
        if (!this.provider.canGetArtifact(this.instance)) {
            return Optional.empty();
        }
        byte[] artifact = this.provider.getArtifact(this.instance, reason);
        if (artifact == null || artifact.length == 0) {
            return Optional.empty();
        }
        Path collectionPath = this.getCollectionPath();
        if (!collectionPath.toFile().exists()) {
            try {
                Files.createDirectories(collectionPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                String messageTemplate = "Unable to create collection directory ({}); no artifact was captured";
                this.provider.getLogger().warn(messageTemplate, (Object)collectionPath, (Object)e);
                return Optional.empty();
            }
        }
        try {
            artifactPath = PathUtils.getNextPath((Path)collectionPath, (String)this.getArtifactBaseName(), (String)this.provider.getArtifactExtension());
        }
        catch (IOException e) {
            this.provider.getLogger().warn("Unable to get output path; no artifact was captured", (Throwable)e);
            return Optional.empty();
        }
        try {
            this.provider.getLogger().info("Saving captured artifact to ({}).", (Object)artifactPath);
            Files.write(artifactPath, artifact, new OpenOption[0]);
        }
        catch (IOException e) {
            this.provider.getLogger().warn("I/O error saving to ({}); no artifact was captured", (Object)artifactPath, (Object)e);
            return Optional.empty();
        }
        this.recordArtifactPath(artifactPath);
        return Optional.of(artifactPath);
    }

    private Path getCollectionPath() {
        Path collectionPath = PathUtils.ReportsDirectory.getPathForObject((Object)this.instance);
        return collectionPath.resolve(this.provider.getArtifactPath(this.instance));
    }

    private String getArtifactBaseName() {
        Object[] parameters = new Object[]{};
        if (this.instance instanceof ArtifactParams) {
            parameters = ((ArtifactParams)this.instance).getParameters();
        }
        if (parameters.length == 0) {
            return this.description.getMethodName();
        }
        int hashcode = Arrays.deepHashCode(parameters);
        String hashStr = String.format("%08X", hashcode);
        return this.description.getMethodName() + "-" + hashStr;
    }

    private void recordArtifactPath(Path artifactPath) {
        this.artifactPaths.add(artifactPath);
    }

    public Optional<List<Path>> retrieveArtifactPaths() {
        if (this.artifactPaths.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.artifactPaths);
    }

    public T getArtifactProvider() {
        return this.provider;
    }

    public Description getDescription() {
        return this.description;
    }

    public static <S extends ArtifactCollector<? extends ArtifactType>> Optional<S> getWatcher(Description description, Class<S> watcherType) {
        List<ArtifactCollector<? extends ArtifactType>> watcherList = watcherMap.get(description);
        if (watcherList != null) {
            for (ArtifactCollector<? extends ArtifactType> watcher : watcherList) {
                if (((Object)watcher).getClass() != watcherType) continue;
                return Optional.of(watcher);
            }
        }
        return Optional.empty();
    }
}

