/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.RunReflectiveCall;
import com.nordstrom.automation.junit.TestClassWatcher;
import com.nordstrom.automation.junit.TestClassWatcher2;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTestClass {
    private static final ServiceLoader<TestClassWatcher> classWatcherLoader;
    private static final ServiceLoader<TestClassWatcher2> classWatcher2Loader;
    private static final Logger LOGGER;
    private static final Map<TestClass, Object> TESTCLASS_TO_RUNNER;
    private static final Map<Object, TestClass> METHOD_TO_TESTCLASS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestClass intercept(@This Object runner, @SuperCall Callable<?> proxy) throws Exception {
        TestClass testClass = (TestClass)LifecycleHooks.callProxy(proxy);
        TESTCLASS_TO_RUNNER.put(testClass, runner);
        for (Object method : testClass.getAnnotatedMethods()) {
            METHOD_TO_TESTCLASS.put(method, testClass);
        }
        ServiceLoader<TestClassWatcher2> serviceLoader = classWatcherLoader;
        synchronized (serviceLoader) {
            for (TestClassWatcher testClassWatcher : classWatcherLoader) {
                testClassWatcher.testClassCreated(testClass, runner);
            }
        }
        serviceLoader = classWatcher2Loader;
        synchronized (serviceLoader) {
            for (TestClassWatcher2 testClassWatcher2 : classWatcher2Loader) {
                testClassWatcher2.testClassCreated(testClass, runner);
            }
        }
        CreateTestClass.attachRunnerScheduler(testClass, runner);
        return testClass;
    }

    private static void attachRunnerScheduler(TestClass testClass, Object runner) {
        try {
            RunnerScheduler scheduler = (RunnerScheduler)LifecycleHooks.getFieldValue(runner, "scheduler");
            LifecycleHooks.setFieldValue(runner, "scheduler", CreateTestClass.createRunnerScheduler(testClass, runner, scheduler));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.warn("Unable to attach notifying runner scheduler", (Throwable)e);
        }
    }

    private static RunnerScheduler createRunnerScheduler(final TestClass testClass, final Object runner, final RunnerScheduler scheduler) {
        return new RunnerScheduler(){
            private AtomicBoolean scheduled = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void schedule(Runnable childStatement) {
                if (this.scheduled.compareAndSet(false, true)) {
                    ServiceLoader serviceLoader = classWatcherLoader;
                    synchronized (serviceLoader) {
                        for (TestClassWatcher watcher : classWatcherLoader) {
                            watcher.testClassStarted(testClass);
                        }
                    }
                    serviceLoader = classWatcher2Loader;
                    synchronized (serviceLoader) {
                        for (TestClassWatcher watcher : classWatcher2Loader) {
                            watcher.testClassStarted(testClass, runner);
                        }
                    }
                }
                RunReflectiveCall.fireTestStarted(testClass, childStatement);
                if (scheduler != null) {
                    scheduler.schedule(childStatement);
                } else {
                    childStatement.run();
                }
                RunReflectiveCall.fireTestFinished(testClass);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                ServiceLoader serviceLoader = classWatcherLoader;
                synchronized (serviceLoader) {
                    for (TestClassWatcher watcher : classWatcherLoader) {
                        watcher.testClassFinished(testClass);
                    }
                }
                serviceLoader = classWatcher2Loader;
                synchronized (serviceLoader) {
                    for (TestClassWatcher watcher : classWatcher2Loader) {
                        watcher.testClassFinished(testClass, runner);
                    }
                }
            }
        };
    }

    static Object getRunnerFor(TestClass testClass) {
        Object runner = TESTCLASS_TO_RUNNER.get(testClass);
        if (runner != null) {
            return runner;
        }
        throw new IllegalArgumentException("No associated runner was found for specified test class");
    }

    static TestClass getTestClassWith(Object method) {
        TestClass testClass = METHOD_TO_TESTCLASS.get(method);
        if (testClass != null) {
            return testClass;
        }
        throw new IllegalArgumentException("No associated test class was found for specified framework method");
    }

    static {
        LOGGER = LoggerFactory.getLogger(CreateTestClass.class);
        TESTCLASS_TO_RUNNER = new ConcurrentHashMap<TestClass, Object>();
        METHOD_TO_TESTCLASS = new ConcurrentHashMap<Object, TestClass>();
        classWatcherLoader = ServiceLoader.load(TestClassWatcher.class);
        classWatcher2Loader = ServiceLoader.load(TestClassWatcher2.class);
    }
}

