/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.CreateTestClass;
import com.nordstrom.automation.junit.Hooked;
import com.nordstrom.automation.junit.JUnitConfig;
import com.nordstrom.automation.junit.MutableTest;
import com.nordstrom.automation.junit.RunChild;
import com.nordstrom.automation.junit.RunReflectiveCall;
import com.nordstrom.automation.junit.RunnerWatcher;
import com.nordstrom.automation.junit.ShutdownListener;
import com.nordstrom.automation.junit.TestObjectWatcher;
import com.nordstrom.common.base.UncheckedThrow;
import com.nordstrom.common.file.PathUtils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.TestClass;

public class LifecycleHooks {
    private static JUnitConfig config;

    private LifecycleHooks() {
        throw new AssertionError((Object)"LifecycleHooks is a static utility class that cannot be instantiated");
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        LifecycleHooks.installTransformer(instrumentation);
    }

    public static ClassFileTransformer installTransformer(Instrumentation instrumentation) {
        TypeDescription reflectiveCallable = TypePool.Default.ofSystemLoader().describe("org.junit.internal.runners.model.ReflectiveCallable").resolve();
        TypeDescription parentRunner = TypePool.Default.ofSystemLoader().describe("org.junit.runners.ParentRunner").resolve();
        TypeDescription blockJUnit4ClassRunner = TypePool.Default.ofSystemLoader().describe("org.junit.runners.BlockJUnit4ClassRunner").resolve();
        return new AgentBuilder.Default().type((ElementMatcher)ElementMatchers.isSubTypeOf((TypeDescription)reflectiveCallable)).transform((builder, type, classLoader, module) -> builder.method((ElementMatcher)ElementMatchers.named((String)"runReflectiveCall")).intercept((Implementation)MethodDelegation.to(RunReflectiveCall.class)).implement(new Type[]{Hooked.class})).type((ElementMatcher)ElementMatchers.is((Object)parentRunner)).transform((builder, type, classLoader, module) -> builder.method((ElementMatcher)ElementMatchers.named((String)"createTestClass")).intercept((Implementation)MethodDelegation.to(CreateTestClass.class)).method((ElementMatcher)ElementMatchers.named((String)"run")).intercept((Implementation)MethodDelegation.to(Run.class)).implement(new Type[]{Hooked.class})).type((ElementMatcher)ElementMatchers.is((Object)blockJUnit4ClassRunner)).transform((builder, type, classLoader, module) -> builder.method((ElementMatcher)ElementMatchers.named((String)"createTest")).intercept((Implementation)MethodDelegation.to(CreateTest.class)).method((ElementMatcher)ElementMatchers.named((String)"runChild")).intercept((Implementation)MethodDelegation.to(RunChild.class)).implement(new Type[]{Hooked.class})).installOn(instrumentation);
    }

    static Thread getShutdownHook(final ShutdownListener listener) {
        return new Thread(){

            @Override
            public void run() {
                listener.onShutdown();
            }
        };
    }

    static synchronized JUnitConfig getConfig() {
        if (config == null) {
            config = JUnitConfig.getConfig();
        }
        return config;
    }

    public static TestClass getTestClassFor(Object target) {
        return CreateTest.getTestClassFor(target);
    }

    public static Object getRunnerFor(TestClass testClass) {
        return CreateTestClass.getRunnerFor(testClass);
    }

    public static TestClass getTestClassWith(Object method) {
        return CreateTestClass.getTestClassWith(method);
    }

    public static Object getParentOf(Object child) {
        return Run.getParentOf(child);
    }

    public static TestClass getTestClassOf(Object runner) {
        return (TestClass)LifecycleHooks.invoke(runner, "getTestClass", new Object[0]);
    }

    public static boolean hasConfiguration(TestClass testClass) {
        AtomicTest atomicTest = RunReflectiveCall.getAtomicTestFor(testClass);
        return atomicTest.hasConfiguration();
    }

    public static Description describeChild(Object target, Object child) {
        TestClass testClass = LifecycleHooks.getTestClassFor(target);
        Object runner = LifecycleHooks.getRunnerFor(testClass);
        return (Description)LifecycleHooks.invoke(runner, "describeChild", child);
    }

    static void applyTimeout(Object testObj) {
        if (LifecycleHooks.getConfig().containsKey(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key())) {
            long defaultTimeout = LifecycleHooks.getConfig().getLong(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key());
            for (Method method : testObj.getClass().getDeclaredMethods()) {
                Test annotation = method.getDeclaredAnnotation(Test.class);
                if (annotation == null || annotation.timeout() >= defaultTimeout) continue;
                MutableTest.proxyFor(method).setTimeout(defaultTimeout);
            }
        }
    }

    public static Class<?> getInstanceClass(Object instance) {
        Class<?> clazz = instance.getClass();
        return instance instanceof Hooked ? clazz.getSuperclass() : clazz;
    }

    static String getSubclassName(Object testObj) {
        Class<?> testClass = testObj.getClass();
        String testClassName = testClass.getSimpleName();
        String testPackageName = testClass.getPackage().getName();
        PathUtils.ReportsDirectory constant = PathUtils.ReportsDirectory.fromObject((Object)testObj);
        switch (constant) {
            case FAILSAFE_2: 
            case FAILSAFE_3: 
            case SUREFIRE_2: 
            case SUREFIRE_3: 
            case SUREFIRE_4: {
                return testPackageName + ".Hooked" + testClassName;
            }
        }
        return testClass.getCanonicalName() + "Hooked";
    }

    static <T> T invoke(Object target, String methodName, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        Exception thrown = null;
        for (Class<?> current = target.getClass(); current != null; current = current.getSuperclass()) {
            try {
                Method method = current.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return (T)method.invoke(target, parameters);
            }
            catch (NoSuchMethodException e) {
                thrown = e;
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                thrown = e;
                break;
            }
        }
        throw UncheckedThrow.throwUnchecked(thrown);
    }

    static Field getDeclaredField(Object target, String name) throws NoSuchFieldException, SecurityException {
        Exception thrown = null;
        for (Class<?> current = target.getClass(); current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                thrown = e;
                continue;
            }
            catch (SecurityException e) {
                thrown = e;
                break;
            }
        }
        throw UncheckedThrow.throwUnchecked(thrown);
    }

    static <T> T getFieldValue(Object target, String name) throws IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field = LifecycleHooks.getDeclaredField(target, name);
        field.setAccessible(true);
        return (T)field.get(target);
    }

    static void setFieldValue(Object target, String name, Object value) throws IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field = LifecycleHooks.getDeclaredField(target, name);
        field.setAccessible(true);
        field.set(target, value);
    }

    static Object callProxy(Callable<?> proxy) throws Exception {
        try {
            return proxy.call();
        }
        catch (InvocationTargetException e) {
            throw UncheckedThrow.throwUnchecked((Throwable)e.getCause());
        }
    }

    static {
        for (ShutdownListener listener : ServiceLoader.load(ShutdownListener.class)) {
            Runtime.getRuntime().addShutdownHook(LifecycleHooks.getShutdownHook(listener));
        }
    }

    public static class CreateTest {
        private static final ServiceLoader<TestObjectWatcher> objectWatcherLoader;
        private static final Map<Object, TestClass> TARGET_TO_TESTCLASS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RuntimeType
        public static Object intercept(@This Object runner, @SuperCall Callable<?> proxy) throws Exception {
            Object testObj = LifecycleHooks.callProxy(proxy);
            TARGET_TO_TESTCLASS.put(testObj, LifecycleHooks.getTestClassOf(runner));
            LifecycleHooks.applyTimeout(testObj);
            ServiceLoader<TestObjectWatcher> serviceLoader = objectWatcherLoader;
            synchronized (serviceLoader) {
                for (TestObjectWatcher watcher : objectWatcherLoader) {
                    watcher.testObjectCreated(testObj, TARGET_TO_TESTCLASS.get(testObj));
                }
            }
            return testObj;
        }

        static TestClass getTestClassFor(Object target) {
            TestClass testClass = TARGET_TO_TESTCLASS.get(target);
            if (testClass != null) {
                return testClass;
            }
            throw new IllegalArgumentException("No associated test class was found for specified instance");
        }

        static {
            TARGET_TO_TESTCLASS = new ConcurrentHashMap<Object, TestClass>();
            objectWatcherLoader = ServiceLoader.load(TestObjectWatcher.class);
        }
    }

    public static class Run {
        private static final ServiceLoader<RunListener> runListenerLoader;
        private static final ServiceLoader<RunnerWatcher> runnerWatcherLoader;
        private static final Set<RunNotifier> NOTIFIERS;
        private static final Map<Object, Object> CHILD_TO_PARENT;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void intercept(@This Object runner, @SuperCall Callable<?> proxy, @Argument(value=0) RunNotifier notifier) throws Exception {
            List children = (List)LifecycleHooks.invoke(runner, "getChildren", new Object[0]);
            for (Object child : children) {
                CHILD_TO_PARENT.put(child, runner);
            }
            if (NOTIFIERS.add(notifier)) {
                Description description = (Description)LifecycleHooks.invoke(runner, "getDescription", new Object[0]);
                Iterator<RunnerWatcher> iterator = runListenerLoader;
                synchronized (iterator) {
                    for (RunListener listener : runListenerLoader) {
                        notifier.addListener(listener);
                        listener.testRunStarted(description);
                    }
                }
            }
            ServiceLoader<RunnerWatcher> serviceLoader = runnerWatcherLoader;
            synchronized (serviceLoader) {
                for (RunnerWatcher watcher : runnerWatcherLoader) {
                    watcher.runStarted(runner);
                }
            }
            LifecycleHooks.callProxy(proxy);
            serviceLoader = runnerWatcherLoader;
            synchronized (serviceLoader) {
                for (RunnerWatcher watcher : runnerWatcherLoader) {
                    watcher.runFinished(runner);
                }
            }
        }

        static Object getParentOf(Object child) {
            return CHILD_TO_PARENT.get(child);
        }

        static {
            NOTIFIERS = new CopyOnWriteArraySet<RunNotifier>();
            CHILD_TO_PARENT = new ConcurrentHashMap<Object, Object>();
            runListenerLoader = ServiceLoader.load(RunListener.class);
            runnerWatcherLoader = ServiceLoader.load(RunnerWatcher.class);
        }
    }
}

