/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.MethodWatcher;
import com.nordstrom.automation.junit.RunWatcher;
import com.nordstrom.common.base.UncheckedThrow;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class RunReflectiveCall {
    private static final ServiceLoader<MethodWatcher> methodWatcherLoader;
    private static final ServiceLoader<RunWatcher> runWatcherLoader;
    private static final Map<FrameworkMethod, Object> METHOD_TO_TARGET;
    private static final Map<TestClass, AtomicTest> TESTCLASS_TO_ATOMICTEST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RuntimeType
    public static Object intercept(@This Object callable, @SuperCall Callable<?> proxy) throws Exception {
        FrameworkMethod method = null;
        Object target = null;
        Object[] params = null;
        try {
            Object owner = LifecycleHooks.getFieldValue(callable, "this$0");
            if (owner instanceof FrameworkMethod) {
                method = (FrameworkMethod)owner;
                target = LifecycleHooks.getFieldValue(callable, "val$target");
                params = (Object[])LifecycleHooks.getFieldValue(callable, "val$params");
                if (target != null) {
                    METHOD_TO_TARGET.put(method, target);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException owner) {
            // empty catch block
        }
        if (method == null) {
            return LifecycleHooks.callProxy(proxy);
        }
        Object result = null;
        Throwable thrown = null;
        ServiceLoader<MethodWatcher> serviceLoader = methodWatcherLoader;
        synchronized (serviceLoader) {
            for (MethodWatcher watcher : methodWatcherLoader) {
                watcher.beforeInvocation(target, method, params);
            }
        }
        try {
            result = LifecycleHooks.callProxy(proxy);
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            serviceLoader = methodWatcherLoader;
            synchronized (serviceLoader) {
                for (MethodWatcher watcher : methodWatcherLoader) {
                    watcher.afterInvocation(target, method, thrown);
                }
            }
        }
        if (thrown != null) {
            RunReflectiveCall.getAtomicTestFor(method).setThrowable(thrown);
            throw UncheckedThrow.throwUnchecked((Throwable)thrown);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireTestStarted(TestClass testClass, Runnable runnable) {
        AtomicTest atomicTest = RunReflectiveCall.createAtomicTest(testClass, runnable);
        if (atomicTest != null) {
            ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
            synchronized (serviceLoader) {
                for (RunWatcher watcher : runWatcherLoader) {
                    watcher.testStarted(atomicTest.getIdentity(), atomicTest.getTestClass());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireTestFinished(TestClass testClass) {
        AtomicTest atomicTest = TESTCLASS_TO_ATOMICTEST.get(testClass);
        if (atomicTest != null) {
            ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
            synchronized (serviceLoader) {
                for (RunWatcher watcher : runWatcherLoader) {
                    RunReflectiveCall.notifyIfTestFailed(watcher, atomicTest);
                    watcher.testFinished(atomicTest.getIdentity(), atomicTest.getTestClass());
                }
            }
        }
    }

    private static void notifyIfTestFailed(RunWatcher watcher, AtomicTest atomicTest) {
        Throwable thrown = atomicTest.getThrowable();
        if (thrown != null) {
            if (thrown instanceof AssumptionViolatedException) {
                watcher.testAssumptionFailure(atomicTest.getIdentity(), atomicTest.getTestClass(), (AssumptionViolatedException)thrown);
            } else {
                watcher.testFailure(atomicTest.getIdentity(), atomicTest.getTestClass(), thrown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireTestIgnored(Object runner, FrameworkMethod method) {
        TestClass testClass = LifecycleHooks.getTestClassOf(runner);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testIgnored(method, testClass);
            }
        }
    }

    public static Object getTargetFor(FrameworkMethod method) {
        Object target = METHOD_TO_TARGET.get(method);
        if (target != null) {
            return target;
        }
        throw new IllegalArgumentException("No associated test class instance was found for the specified method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<MethodWatcher> getAttachedWatcher(Class<? extends MethodWatcher> watcherType) {
        Objects.requireNonNull(watcherType, "[watcherType] must be non-null");
        ServiceLoader<MethodWatcher> serviceLoader = methodWatcherLoader;
        synchronized (serviceLoader) {
            for (MethodWatcher watcher : methodWatcherLoader) {
                if (watcher.getClass() != watcherType) continue;
                return Optional.of(watcher);
            }
        }
        return Optional.empty();
    }

    static AtomicTest createAtomicTest(TestClass testClass, Runnable runnable) {
        Object runner = null;
        Object child = null;
        AtomicTest atomicTest = null;
        try {
            runner = LifecycleHooks.getFieldValue(runnable, "this$0");
            child = LifecycleHooks.getFieldValue(runnable, "val$each");
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (child instanceof FrameworkMethod) {
            atomicTest = new AtomicTest(runner, testClass, child);
            TESTCLASS_TO_ATOMICTEST.put(testClass, atomicTest);
        }
        return atomicTest;
    }

    public static AtomicTest getAtomicTestFor(TestClass testClass) {
        AtomicTest atomicTest = TESTCLASS_TO_ATOMICTEST.get(testClass);
        if (atomicTest != null) {
            return atomicTest;
        }
        throw new IllegalArgumentException("No associated atomic test was found for the specified test class");
    }

    public static AtomicTest getAtomicTestFor(FrameworkMethod method) {
        for (AtomicTest atomicTest : TESTCLASS_TO_ATOMICTEST.values()) {
            if (!atomicTest.includes(method)) continue;
            return atomicTest;
        }
        throw new IllegalArgumentException("No associated atomic test was found for the specified method");
    }

    static {
        METHOD_TO_TARGET = new ConcurrentHashMap<FrameworkMethod, Object>();
        TESTCLASS_TO_ATOMICTEST = new ConcurrentHashMap<TestClass, AtomicTest>();
        methodWatcherLoader = ServiceLoader.load(MethodWatcher.class);
        runWatcherLoader = ServiceLoader.load(RunWatcher.class);
    }
}

