/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.ArtifactType;
import com.nordstrom.automation.junit.AtomIdentity;
import com.nordstrom.common.file.PathUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.runner.Description;

public class ArtifactCollector<T extends ArtifactType>
extends AtomIdentity {
    private static final Map<Description, List<ArtifactCollector<? extends ArtifactType>>> watcherMap = new ConcurrentHashMap<Description, List<ArtifactCollector<? extends ArtifactType>>>();
    private final T provider;
    private final List<Path> artifactPaths = new ArrayList<Path>();

    public ArtifactCollector(Object instance, T provider) {
        super(instance);
        this.provider = provider;
    }

    @Override
    public void starting(Description description) {
        super.starting(description);
        List watcherList = watcherMap.computeIfAbsent(description, k -> new ArrayList());
        watcherList.add(this);
    }

    public void failed(Throwable e, Description description) {
        this.captureArtifact(e);
    }

    public Optional<Path> captureArtifact(Throwable reason) {
        Path artifactPath;
        if (!this.provider.canGetArtifact(this.getInstance())) {
            return Optional.empty();
        }
        byte[] artifact = this.provider.getArtifact(this.getInstance(), reason);
        if (artifact == null || artifact.length == 0) {
            return Optional.empty();
        }
        Path collectionPath = this.getCollectionPath();
        if (!collectionPath.toFile().exists()) {
            try {
                Files.createDirectories(collectionPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                String messageTemplate = "Unable to create collection directory ({}); no artifact was captured";
                Optional.ofNullable(this.provider.getLogger()).ifPresent(l -> l.warn(messageTemplate, (Object)collectionPath, (Object)e));
                return Optional.empty();
            }
        }
        try {
            artifactPath = PathUtils.getNextPath((Path)collectionPath, (String)this.getArtifactBaseName(), (String)this.provider.getArtifactExtension());
        }
        catch (IOException e) {
            Optional.ofNullable(this.provider.getLogger()).ifPresent(l -> l.warn("Unable to get output path; no artifact was captured", (Throwable)e));
            return Optional.empty();
        }
        try {
            Optional.ofNullable(this.provider.getLogger()).ifPresent(l -> l.info("Saving captured artifact to ({}).", (Object)artifactPath));
            Files.write(artifactPath, artifact, new OpenOption[0]);
        }
        catch (IOException e) {
            Optional.ofNullable(this.provider.getLogger()).ifPresent(l -> l.warn("I/O error saving to ({}); no artifact was captured", (Object)artifactPath, (Object)e));
            return Optional.empty();
        }
        this.recordArtifactPath(artifactPath);
        return Optional.of(artifactPath);
    }

    private Path getCollectionPath() {
        Path collectionPath = PathUtils.ReportsDirectory.getPathForObject((Object)this.getInstance());
        return collectionPath.resolve(this.provider.getArtifactPath(this.getInstance()));
    }

    private String getArtifactBaseName() {
        int hashcode = this.getParameters().hashCode();
        if (hashcode != 0) {
            String hashStr = String.format("%08X", hashcode);
            return this.getDescription().getMethodName() + "-" + hashStr;
        }
        return this.getDescription().getMethodName();
    }

    private void recordArtifactPath(Path artifactPath) {
        this.artifactPaths.add(artifactPath);
    }

    public Optional<List<Path>> retrieveArtifactPaths() {
        if (this.artifactPaths.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.artifactPaths);
    }

    public T getArtifactProvider() {
        return this.provider;
    }

    public static <S extends ArtifactCollector<? extends ArtifactType>> Optional<S> getWatcher(Description description, Class<S> watcherType) {
        List<ArtifactCollector<? extends ArtifactType>> watcherList = watcherMap.get(description);
        if (watcherList != null) {
            for (ArtifactCollector<? extends ArtifactType> watcher : watcherList) {
                if (watcher.getClass() != watcherType) continue;
                return Optional.of(watcher);
            }
        }
        return Optional.empty();
    }
}

