/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.google.common.base.Optional;
import com.nordstrom.automation.junit.DepthGauge;
import com.nordstrom.automation.junit.JUnitWatcher;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.TestObjectWatcher;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTest {
    private static final ServiceLoader<TestObjectWatcher> objectWatcherLoader;
    private static final Map<Object, Object> TARGET_TO_RUNNER;
    private static final Map<Object, Object> RUNNER_TO_TARGET;
    private static final ThreadLocal<DepthGauge> DEPTH;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RuntimeType
    public static Object intercept(@This Object runner, @SuperCall Callable<?> proxy) throws Exception {
        Object testObj;
        try {
            DEPTH.get().increaseDepth();
            testObj = LifecycleHooks.callProxy(proxy);
        }
        finally {
            DEPTH.get().decreaseDepth();
        }
        TARGET_TO_RUNNER.put(testObj, runner);
        RUNNER_TO_TARGET.put(runner, testObj);
        if (DEPTH.get().atGroundLevel()) {
            LOGGER.debug("testObjectCreated: {}", testObj);
            ServiceLoader<TestObjectWatcher> serviceLoader = objectWatcherLoader;
            synchronized (serviceLoader) {
                for (TestObjectWatcher watcher : objectWatcherLoader) {
                    watcher.testObjectCreated(testObj, runner);
                }
            }
        }
        return testObj;
    }

    static Object getRunnerForTarget(Object target) {
        return TARGET_TO_RUNNER.get(target);
    }

    static Object getTargetForRunner(Object runner) {
        return RUNNER_TO_TARGET.get(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends JUnitWatcher> Optional<T> getAttachedWatcher(Class<T> watcherType) {
        if (TestObjectWatcher.class.isAssignableFrom(watcherType)) {
            ServiceLoader<TestObjectWatcher> serviceLoader = objectWatcherLoader;
            synchronized (serviceLoader) {
                for (TestObjectWatcher watcher : objectWatcherLoader) {
                    if (watcher.getClass() != watcherType) continue;
                    return Optional.of((Object)watcher);
                }
            }
        }
        return Optional.absent();
    }

    static {
        TARGET_TO_RUNNER = new ConcurrentHashMap<Object, Object>();
        RUNNER_TO_TARGET = new ConcurrentHashMap<Object, Object>();
        LOGGER = LoggerFactory.getLogger(CreateTest.class);
        objectWatcherLoader = ServiceLoader.load(TestObjectWatcher.class);
        DEPTH = new ThreadLocal<DepthGauge>(){

            @Override
            protected DepthGauge initialValue() {
                return new DepthGauge();
            }
        };
    }
}

