/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcExtendedRequest;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import java.io.IOException;

public class LDAPExtendedRequest
extends LDAPMessage {
    public LDAPExtendedRequest() {
        super(23);
    }

    public LDAPExtendedRequest(LDAPExtendedOperation op, LDAPControl[] cont) {
        super(23, new RfcExtendedRequest(new RfcLDAPOID(op.getID()), op.getValue() != null ? new ASN1OctetString(op.getValue()) : null), cont);
    }

    public LDAPExtendedOperation getExtendedOperation() {
        RfcExtendedRequest xreq = (RfcExtendedRequest)this.getASN1Object().get(1);
        ASN1Tagged tag = (ASN1Tagged)xreq.get(0);
        RfcLDAPOID oid = (RfcLDAPOID)tag.taggedValue();
        String requestID = oid.stringValue();
        byte[] requestValue = null;
        if (xreq.size() >= 2) {
            tag = (ASN1Tagged)xreq.get(1);
            ASN1OctetString value = (ASN1OctetString)tag.taggedValue();
            requestValue = value.byteValue();
        }
        return new LDAPExtendedOperation(requestID, requestValue);
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPExtendedRequest)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPExtendedRequest object");
        }
        LDAPExtendedRequest tmp = (LDAPExtendedRequest)readObject;
        LDAPExtendedOperation extendedOp = tmp.getExtendedOperation();
        tmp = null;
        RfcExtendedRequest operation = new RfcExtendedRequest(new RfcLDAPOID(extendedOp.getID()), extendedOp.getValue() != null ? new ASN1OctetString(extendedOp.getValue()) : null);
        this.message = new RfcLDAPMessage(operation, asn1Ctrls);
        readObject = null;
    }
}

