/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPException;
import com.novell.ldap.resources.ResourcesHandler;

public class LDAPReferralException
extends LDAPException {
    private String failedReferral = null;
    private String[] referrals = null;

    public LDAPReferralException() {
    }

    public LDAPReferralException(String message) {
        super(message, 10, null);
    }

    public LDAPReferralException(String message, Object[] arguments) {
        super(message, arguments, 10, (String)null);
    }

    public LDAPReferralException(String message, Throwable rootException) {
        super(message, 10, null, rootException);
    }

    public LDAPReferralException(String message, Object[] arguments, Throwable rootException) {
        super(message, arguments, 10, null, rootException);
    }

    public LDAPReferralException(String message, int resultCode, String serverMessage) {
        super(message, resultCode, serverMessage);
    }

    public LDAPReferralException(String message, Object[] arguments, int resultCode, String serverMessage) {
        super(message, arguments, resultCode, serverMessage);
    }

    public LDAPReferralException(String message, int resultCode, String serverMessage, Throwable rootException) {
        super(message, resultCode, serverMessage, rootException);
    }

    public LDAPReferralException(String message, Object[] arguments, int resultCode, String serverMessage, Throwable rootException) {
        super(message, arguments, resultCode, serverMessage, rootException);
    }

    public String getFailedReferral() {
        return this.failedReferral;
    }

    public String[] getReferrals() {
        return this.referrals;
    }

    public void setFailedReferral(String url) {
        this.failedReferral = url;
    }

    void setReferrals(String[] urls) {
        this.referrals = urls;
    }

    public String toString() {
        String tmsg;
        String msg = this.getExceptionString("LDAPReferralException");
        if (this.failedReferral != null) {
            tmsg = ResourcesHandler.getMessage("FAILED_REFERRAL", new Object[]{"LDAPReferralException", this.failedReferral});
            if (tmsg.equalsIgnoreCase("SERVER_MSG")) {
                tmsg = "LDAPReferralException: Failed Referral: " + this.failedReferral;
            }
            msg = msg + '\n' + tmsg;
        }
        if (this.referrals != null) {
            for (int i = 0; i < this.referrals.length; ++i) {
                tmsg = ResourcesHandler.getMessage("REFERRAL_ITEM", new Object[]{"LDAPReferralException", this.referrals[i]});
                if (tmsg.equalsIgnoreCase("SERVER_MSG")) {
                    tmsg = "LDAPReferralException: Referral: " + this.referrals[i];
                }
                msg = msg + '\n' + tmsg;
            }
        }
        return msg;
    }
}

