/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class GetEffectivePrivilegesResponse
extends LDAPExtendedResponse {
    private int privileges;

    public GetEffectivePrivilegesResponse(RfcLDAPMessage rfcMessage) throws IOException {
        super(rfcMessage);
        if (this.getResultCode() == 0) {
            byte[] returnedValue = this.getValue();
            if (returnedValue == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder decoder = new LBERDecoder();
            if (decoder == null) {
                throw new IOException("Decoding error");
            }
            ASN1Integer asn1_privileges = (ASN1Integer)decoder.decode(returnedValue);
            if (asn1_privileges == null) {
                throw new IOException("Decoding error");
            }
            this.privileges = asn1_privileges.intValue();
        } else {
            this.privileges = 0;
        }
    }

    public int getPrivileges() {
        return this.privileges;
    }
}

