/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPCompareRequest;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.rfc2251.RfcFilter;
import com.novell.ldap.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class DSMLHandler
extends DefaultHandler
implements ContentHandler,
ErrorHandler {
    private boolean isAddRequest;
    private ArrayList queue = new ArrayList();
    private LDAPMessage message = null;
    private LDAPEntry entry = null;
    private LDAPAttributeSet attrSet = null;
    private ArrayList attributeValues = new ArrayList();
    private ArrayList attributeNames = new ArrayList();
    private ArrayList modlist = new ArrayList();
    private LDAPSearchConstraints searchCons = null;
    private String attrName = null;
    private String dn;
    private String newRDN;
    private String newSuperior;
    private String requestName;
    private byte[] requestValue;
    private StringBuffer value;
    private boolean typesOnly;
    private boolean deleteOldRDN;
    private boolean isBase64;
    private int scope;
    private int operation;
    private RfcFilter filter;
    private boolean isDNMatching;
    private String matchingRule;
    private ArrayList controls = new ArrayList();
    private ArrayList referrallist = new ArrayList();
    private int responsetype = 0;
    private int responsecode = 0;
    private String responseDesc = null;
    private String errorMessage = null;
    private static final int START = 0;
    private static final int BATCH_REQUEST = 1;
    private static final int AUTH_REQUEST = 2;
    private static final int MODIFY_REQUEST = 3;
    private static final int SEARCH_REQUEST = 4;
    private static final int ADD_REQUEST = 5;
    private static final int DELETE_REQUEST = 6;
    private static final int MODIFY_DN_REQUEST = 7;
    private static final int COMPARE_REQUEST = 8;
    private static final int EXTENDED_REQUEST = 9;
    private static final int ASSERTION = 10;
    private static final int VALUE = 11;
    private static final int ATTRIBUTES = 12;
    private static final int ATTRIBUTE = 13;
    private static final int FILTER = 14;
    private static final int AND = 15;
    private static final int OR = 16;
    private static final int NOT = 17;
    private static final int EQUALITY_MATCH = 18;
    private static final int SUBSTRINGS = 19;
    private static final int GREATER_OR_EQUAL = 20;
    private static final int LESS_OR_EQUAL = 21;
    private static final int PRESENT = 22;
    private static final int APPROXIMATE_MATCH = 23;
    private static final int EXTENSIBLE_MATCH = 24;
    private static final int INITIAL = 25;
    private static final int ANY = 26;
    private static final int FINAL = 27;
    private static final int ADD_ATTRIBUTE = 28;
    private static final int MODIFICATION = 29;
    private static final int X_NAME = 30;
    private static final int X_VALUE = 31;
    private static final int CONTROL = 32;
    private static final int BATCH_RESPONSE = 34;
    private static final int ADD_RESPONSE = 35;
    private static final int LDAP_RESPONSE = 36;
    private static final int RESULT_CODE = 37;
    private static final int ERROR_MESSAGE = 38;
    private static final int ERROR_RESPONSE = 53;
    private static final int MESSAGE = 54;
    private static final int REFERRAL_LIST = 39;
    private static final int SEARCH_RESPONSE = 40;
    private static final int SEARCH_RESULT_ENTRY = 41;
    private static final int SEARCH_RESULT_REFERENCE = 42;
    private static final int SEARCH_RESULT_REFERENCE_REF = 43;
    private static final int SEARCH_RESULT_DONE = 44;
    private static final int EXTENDED_RESPONSE = 45;
    private static final int EXTENDED_RESPONSE_NAME = 46;
    private static final int EXTENDED_RESPONSE_RESPONSE = 47;
    private static final int AUTH_RESPONSE = 48;
    private static final int MODIFY_RESPONSE = 49;
    private static final int DEL_RESPONSE = 50;
    private static final int MODIFYDN_RESPONSE = 51;
    private static final int COMPARE_RESPONSE = 52;
    private int state = 0;
    private static final HashMap requestTags = new HashMap(35, 0.25f);
    private int valueState;
    private boolean critical;
    private String oid;
    private String requestID;
    private String batchRequestID;
    private boolean isParallel;
    private boolean isUnordered;
    private boolean isResumeOnError;
    private int prevstate = 0;
    private boolean isextendedstate = false;
    private String searchResponseid;
    private String errorType;
    private ArrayList errors = new ArrayList();

    DSMLHandler() {
    }

    public void startElement(String strNamespaceURI, String strSName, String strQName, Attributes attrs) throws SAXException {
        Integer elementTag = (Integer)requestTags.get(strSName);
        if (elementTag == null) {
            if (this.state != 0) {
                throw new SAXNotRecognizedException("Element name, \"" + strQName + "\" not recognized");
            }
            return;
        }
        int tag = elementTag;
        if (tag == 32) {
            this.handleControl(attrs);
            this.prevstate = this.state;
            this.state = 32;
        } else {
            switch (this.state) {
                case 0: {
                    if (tag == 1 || tag == 34) {
                        this.state = tag;
                        this.parseTagAttributes(tag, attrs);
                        break;
                    }
                    throw new SAXException("Invalid beginning tag :" + strQName);
                }
                case 1: {
                    this.state = tag;
                    if (tag == 5) {
                        this.attrSet = new LDAPAttributeSet();
                    }
                    if (tag == 3) {
                        this.modlist.clear();
                    }
                    this.parseTagAttributes(tag, attrs);
                    break;
                }
                case 34: {
                    if (tag == 35) {
                        this.responsetype = 9;
                        this.state = 36;
                        this.parseTagAttributes(36, attrs);
                    } else if (tag == 40) {
                        this.responsetype = 4;
                        this.parseTagAttributes(tag, attrs);
                        this.state = 40;
                        this.searchResponseid = this.requestID;
                    } else if (tag == 45) {
                        this.responsetype = 24;
                        this.parseTagAttributes(36, attrs);
                        this.state = 45;
                    } else if (tag == 49) {
                        this.responsetype = 7;
                        this.state = 36;
                        this.parseTagAttributes(36, attrs);
                    } else if (tag == 50) {
                        this.responsetype = 11;
                        this.state = 36;
                        this.parseTagAttributes(36, attrs);
                    } else if (tag == 51) {
                        this.responsetype = 13;
                        this.state = 36;
                        this.parseTagAttributes(36, attrs);
                    } else if (tag == 52) {
                        this.responsetype = 15;
                        this.state = 36;
                        this.parseTagAttributes(36, attrs);
                    } else if (tag == 53) {
                        this.responsetype = 16;
                        this.state = 53;
                        this.parseTagAttributes(53, attrs);
                    } else {
                        throw new SAXException("invalid tag: " + strSName);
                    }
                    this.referrallist.clear();
                    break;
                }
                case 40: {
                    if (tag == 44) {
                        this.state = 36;
                        this.responsetype = 5;
                        this.parseTagAttributes(36, attrs);
                        break;
                    }
                    if (tag == 42) {
                        this.referrallist.clear();
                        this.state = 42;
                        break;
                    }
                    if (tag != 41) break;
                    this.state = 41;
                    this.parseTagAttributes(41, attrs);
                    this.attrSet = new LDAPAttributeSet();
                    break;
                }
                case 41: {
                    if (tag != 28) break;
                    this.state = tag;
                    this.attributeValues.clear();
                    this.attrName = attrs.getValue("name");
                    this.isAddRequest = false;
                    break;
                }
                case 42: {
                    if (tag != 43) break;
                    if (this.value == null) {
                        this.value = new StringBuffer();
                    } else {
                        this.value.delete(0, this.value.length());
                    }
                    this.state = 43;
                    break;
                }
                case 45: {
                    if (this.value == null) {
                        this.value = new StringBuffer();
                    } else {
                        this.value.delete(0, this.value.length());
                    }
                    if (tag == 46) {
                        this.state = 46;
                    }
                    if (tag == 47) {
                        this.state = 47;
                        String temp = attrs.getValue("xsi:type");
                        this.isBase64 = temp != null && temp.equals("xsd:base64Binary");
                    }
                    this.isextendedstate = true;
                }
                case 36: {
                    if (tag == 37) {
                        if (attrs.getValue("code") == null) {
                            throw new SAXException("Response Code not provided");
                        }
                        this.responsecode = new Integer(attrs.getValue("code"));
                        this.responseDesc = attrs.getValue("descr");
                        break;
                    }
                    if (tag == 38 || tag == 54) {
                        if (this.value == null) {
                            this.value = new StringBuffer();
                        } else {
                            this.value.delete(0, this.value.length());
                        }
                        this.state = tag;
                        break;
                    }
                    if (tag != 39) break;
                    if (this.value == null) {
                        this.value = new StringBuffer();
                    } else {
                        this.value.delete(0, this.value.length());
                    }
                    this.state = tag;
                    break;
                }
                case 53: {
                    if (this.value == null) {
                        this.value = new StringBuffer();
                    } else {
                        this.value.delete(0, this.value.length());
                    }
                    this.state = tag;
                    break;
                }
                case 4: {
                    if (this.isParallel && this.isUnordered && this.requestID == null) {
                        throw new SAXException("requestID not provided");
                    }
                    if (tag == 12) {
                        this.attributeNames.clear();
                        this.attributeValues.clear();
                        this.state = tag;
                        break;
                    }
                    if (tag == 14) {
                        this.state = 14;
                        this.filter = new RfcFilter();
                        break;
                    }
                    throw new SAXException("invalid searchRequest tag: " + strSName);
                }
                case 2: 
                case 3: {
                    if (this.isParallel && this.isUnordered && this.requestID == null) {
                        throw new SAXException("requestID not provided");
                    }
                    if (tag == 29) {
                        this.state = tag;
                        this.attributeValues.clear();
                        String tempID = this.requestID;
                        this.parseTagAttributes(tag, attrs);
                        this.requestID = tempID;
                        tempID = null;
                        break;
                    }
                    throw new SAXException("invalid modifyRequest tag: " + strSName);
                }
                case 5: {
                    if (this.isParallel && this.isUnordered && this.requestID == null) {
                        throw new SAXException("requestID not provided");
                    }
                    if (tag == 28) {
                        this.state = tag;
                        this.attributeValues.clear();
                        this.attrName = attrs.getValue("name");
                        this.isAddRequest = true;
                        break;
                    }
                    throw new SAXException("invalid addRequest tag: " + strSName);
                }
                case 6: {
                    if (!this.isParallel || !this.isUnordered || this.requestID != null) break;
                    throw new SAXException("requestID not provided");
                }
                case 7: {
                    if (!this.isParallel || !this.isUnordered || this.requestID != null) break;
                    throw new SAXException("requestID not provided");
                }
                case 8: {
                    if (this.isParallel && this.isUnordered && this.requestID == null) {
                        throw new SAXException("requestID not provided");
                    }
                    this.attributeValues.clear();
                    if (tag == 10) {
                        this.attrName = attrs.getValue("name");
                        this.state = tag;
                        break;
                    }
                    throw new SAXException("invalid compareRequest tag: " + strSName);
                }
                case 12: {
                    if (tag == 13) {
                        this.attributeNames.add(attrs.getValue("name"));
                        this.state = tag;
                        break;
                    }
                    throw new SAXException("invalid attributes tag: " + strSName);
                }
                case 19: {
                    if (tag == 25 || tag == 26 || tag == 27) {
                        this.state = tag;
                        this.value = new StringBuffer();
                        break;
                    }
                    throw new SAXException("invalid substrings tag: " + strSName);
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    this.handleFilter(tag, attrs, strSName);
                    this.state = tag;
                    break;
                }
                case 9: {
                    this.attributeValues.clear();
                    if (tag != 30 && tag != 31) break;
                    this.state = tag;
                    this.value = new StringBuffer();
                    break;
                }
                case 10: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 28: 
                case 29: 
                case 32: {
                    if (tag == 11) {
                        this.valueState = this.state;
                        this.state = tag;
                        this.value = new StringBuffer();
                        String temp = attrs.getValue("xsi:type");
                        if (temp != null && temp.equals("xsd:base64Binary")) {
                            this.isBase64 = true;
                            break;
                        }
                        this.isBase64 = false;
                        break;
                    }
                    throw new SAXException("invalid tag: " + strSName);
                }
                default: {
                    throw new SAXException("invalid tag: " + strSName);
                }
            }
        }
    }

    private void handleControl(Attributes attrs) throws SAXException {
        if (this.controls == null) {
            this.controls = new ArrayList();
        }
        this.oid = attrs.getValue("type");
        if (this.oid == null) {
            throw new SAXException("type is mandatory for a Control");
        }
        this.critical = "true".equalsIgnoreCase(attrs.getValue("criticality"));
    }

    private void handleFilter(int tag, Attributes attrs, String strSName) throws SAXException {
        try {
            switch (tag) {
                case 15: {
                    this.filter.startNestedFilter(0);
                    break;
                }
                case 16: {
                    this.filter.startNestedFilter(1);
                    break;
                }
                case 17: {
                    this.filter.startNestedFilter(2);
                    break;
                }
                case 19: {
                    this.attrName = attrs.getValue("name");
                    if (this.attrName == null) {
                        throw new SAXException("The mandatory attribute 'name' is missing from tag <" + strSName + ">");
                    }
                    this.filter.startSubstrings(this.attrName);
                    break;
                }
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    this.attrName = attrs.getValue("name");
                    if (this.attrName == null) {
                        throw new SAXException("The mandatory attribute 'name' is missing from tag <" + strSName + ">");
                    }
                    break;
                }
                case 24: {
                    this.attrName = attrs.getValue("name");
                    String dnAttributes = attrs.getValue("dnAttributes");
                    this.isDNMatching = dnAttributes != null && dnAttributes.equalsIgnoreCase("true");
                    this.matchingRule = attrs.getValue("matchingRule");
                    break;
                }
                default: {
                    throw new SAXException("invalid tag in filter: " + strSName);
                }
            }
        }
        catch (LDAPLocalException e) {
            throw new SAXException("An error occured constructing a filter:" + e.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseTagAttributes(int tag, Attributes attrs) throws SAXException {
        switch (tag) {
            case 53: {
                this.errorType = attrs.getValue("type");
                break;
            }
            case 34: {
                this.batchRequestID = attrs.getValue("requestID");
                break;
            }
            case 36: {
                this.dn = attrs.getValue("matchedDN");
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                this.dn = attrs.getValue("dn");
                if (this.dn == null) {
                    throw new SAXException("DN is Mandatory in SearchResultEntry");
                }
            }
            case 1: {
                this.batchRequestID = attrs.getValue("requestID");
                String temp = attrs.getValue("processing");
                this.isParallel = temp != null && temp.equals("parallel");
                temp = attrs.getValue("responseOrder");
                this.isUnordered = temp != null && temp.equals("unordered");
                temp = attrs.getValue("onError");
                this.isResumeOnError = temp != null && temp.equals("resume");
            }
            case 4: {
                void var5_6;
                int deref;
                String temp = attrs.getValue("derefAliases");
                if (temp == null) {
                    deref = 3;
                } else if (temp.equals("neverDerefAliases")) {
                    deref = 0;
                } else if (temp.equals("derefInSearching")) {
                    deref = 1;
                } else if (temp.equals("derefFindingBaseObj")) {
                    deref = 2;
                } else if (temp.equals("derefAlways")) {
                    deref = 3;
                } else {
                    throw new SAXException("unknown attribute in searchRequest, " + temp);
                }
                temp = attrs.getValue("timeLimit");
                int timeLimit = temp != null ? Integer.parseInt(temp) : 0;
                temp = attrs.getValue("sizeLimit");
                int sizeLimit = temp != null ? Integer.parseInt(temp) : 0;
                this.searchCons = new LDAPSearchConstraints(timeLimit, timeLimit, (int)var5_6, sizeLimit, false, 0, null, 0);
                this.dn = attrs.getValue("dn");
                temp = attrs.getValue("typesOnly");
                if (temp == null) {
                    this.typesOnly = false;
                } else if (new Boolean(temp).booleanValue()) {
                    this.typesOnly = true;
                } else if (!new Boolean(temp).booleanValue()) {
                    this.typesOnly = false;
                } else {
                    throw new SAXException("Invalid value for attribute 'typesOnly'," + temp);
                }
                temp = attrs.getValue("scope");
                if (temp == null) {
                    this.scope = 0;
                } else if (temp.equals("baseObject")) {
                    this.scope = 0;
                } else if (temp.equals("singleLevel")) {
                    this.scope = 1;
                } else if (temp.equals("wholeSubtree")) {
                    this.scope = 2;
                } else if (temp.equals("subordinateSubtree")) {
                    this.scope = 4;
                } else {
                    throw new SAXException("Invalid value for attribute 'scope', " + temp);
                }
                this.filter = null;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.dn = attrs.getValue("dn");
                break;
            }
            case 29: {
                this.attrName = attrs.getValue("name");
                String temp = attrs.getValue("operation");
                if (temp == null || this.attrName == null) {
                    throw new SAXException("Required attribute missing from tag <modification> (operation or name are required)");
                }
                if (temp.equals("add")) {
                    this.operation = 0;
                    break;
                }
                if (temp.equals("replace")) {
                    this.operation = 2;
                    break;
                }
                if (temp.equals("delete")) {
                    this.operation = 1;
                    break;
                }
                throw new SAXException("Invalid value for attribute 'operation': " + temp);
            }
            case 5: {
                this.dn = attrs.getValue("dn");
                break;
            }
            case 6: {
                this.dn = attrs.getValue("dn");
                break;
            }
            case 7: {
                this.dn = attrs.getValue("dn");
                this.newRDN = attrs.getValue("newrdn");
                String temp = attrs.getValue("deleteoldrdn");
                this.deleteOldRDN = temp == null || !temp.equals("false");
                this.newSuperior = attrs.getValue("newSuperior");
                break;
            }
            case 8: {
                this.dn = attrs.getValue("dn");
                break;
            }
        }
        this.requestID = attrs.getValue("requestID");
    }

    public void characters(char[] a, int s, int l) {
        if (this.state == 25 || this.state == 26 || this.state == 27 || this.state == 30 || this.state == 31 || this.state == 11 || this.state == 38 || this.state == 54 || this.state == 53 || this.state == 46 || this.state == 47 || this.state == 39 || this.state == 43) {
            this.value.append(a, s, l);
        }
    }

    public void endElement(String strNamespaceURI, String strSName, String strQName) throws SAXException {
        Integer elementTag = (Integer)requestTags.get(strSName);
        if (elementTag == null) {
            if (this.state != 0) {
                throw new SAXNotRecognizedException("Element name, \"" + strQName + "\" not recognized");
            }
            return;
        }
        int tag = elementTag;
        LDAPControl[] controlarr = null;
        String[] referalarr = null;
        try {
            switch (tag) {
                case 53: {
                    if (this.errorMessage.indexOf(58) != -1) {
                        String num = this.errorMessage.substring(0, this.errorMessage.indexOf(58));
                        try {
                            int errorNum = Integer.parseInt(num);
                            this.errors.add(new LDAPException(this.errorType, errorNum, this.errorMessage.substring(this.errorMessage.indexOf(58) + 1)));
                        }
                        catch (NumberFormatException nfe) {
                            this.errors.add(new LDAPException(this.errorType, 53, this.errorMessage));
                        }
                    } else {
                        this.errors.add(new LDAPException(this.errorType, 53, this.errorMessage));
                    }
                    this.state = 34;
                }
                case 1: 
                case 34: {
                    this.state = 0;
                    break;
                }
                case 43: {
                    String url = new String(this.value.toString().getBytes("UTF-8"));
                    this.referrallist.add(url);
                    this.state = 42;
                    break;
                }
                case 41: {
                    this.state = 40;
                    this.entry = new LDAPEntry(this.dn, this.attrSet);
                    LDAPControl[] cons = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        cons = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPSearchResult(this.entry, cons);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 42: {
                    this.state = 40;
                    if (!this.referrallist.isEmpty()) {
                        referalarr = this.referrallist.toArray(new String[this.referrallist.size()]);
                    }
                    try {
                        this.message = new LDAPSearchResultReference(referalarr);
                    }
                    catch (MalformedURLException e2) {
                        System.out.println("MalformeURL Found");
                    }
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.errorMessage = null;
                    this.controls.clear();
                    this.queue.add(this.message);
                    break;
                }
                case 40: {
                    this.state = 34;
                    break;
                }
                case 44: {
                    this.state = 40;
                    if (this.controls != null && this.controls.size() > 0) {
                        controlarr = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    if (!this.referrallist.isEmpty()) {
                        referalarr = this.referrallist.toArray(new String[this.referrallist.size()]);
                    }
                    this.message = new LDAPResponse(this.responsetype, this.responsecode, this.dn, this.errorMessage, referalarr, controlarr);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.errorMessage = null;
                    this.controls.clear();
                    this.queue.add(this.message);
                    break;
                }
                case 46: {
                    this.state = 45;
                    this.requestName = this.value.toString();
                    break;
                }
                case 47: {
                    this.state = 45;
                    if (this.isBase64) {
                        String temp = this.value.toString();
                        this.requestValue = Base64.decode(temp);
                    } else {
                        this.requestValue = this.value.toString().getBytes("UTF-8");
                    }
                    this.isBase64 = false;
                    break;
                }
                case 45: {
                    this.isextendedstate = false;
                    if (this.controls != null && this.controls.size() > 0) {
                        controlarr = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    if (!this.referrallist.isEmpty()) {
                        referalarr = this.referrallist.toArray(new String[this.referrallist.size()]);
                    }
                    try {
                        this.message = new LDAPExtendedResponse(this.responsecode, this.dn, this.errorMessage, referalarr, controlarr, this.requestName, this.requestValue);
                    }
                    catch (MalformedURLException e1) {
                        System.out.println("MalformeURL Found");
                    }
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.state = 34;
                    this.controls.clear();
                    break;
                }
                case 35: 
                case 49: 
                case 50: 
                case 51: 
                case 52: {
                    this.state = 34;
                    if (this.controls != null && this.controls.size() > 0) {
                        controlarr = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    if (!this.referrallist.isEmpty()) {
                        referalarr = this.referrallist.toArray(new String[this.referrallist.size()]);
                    }
                    this.message = new LDAPResponse(this.responsetype, this.responsecode, this.dn, this.errorMessage, referalarr, controlarr);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.errorMessage = null;
                    this.controls.clear();
                    this.queue.add(this.message);
                    break;
                }
                case 37: {
                    break;
                }
                case 39: {
                    String turl = new String(this.value.toString().getBytes("UTF-8"));
                    this.referrallist.add(turl);
                    this.state = 36;
                    break;
                }
                case 54: {
                    this.errorMessage = new String(this.value.toString().getBytes("UTF-8"));
                    this.state = 53;
                    break;
                }
                case 38: {
                    this.errorMessage = new String(this.value.toString().getBytes("UTF-8"));
                    if (!this.isextendedstate) {
                        this.state = 36;
                        break;
                    }
                    this.state = 45;
                    break;
                }
                case 4: {
                    this.state = 1;
                    if (this.controls != null && this.controls.size() > 0) {
                        this.searchCons.setControls(this.controls.toArray(new LDAPControl[this.controls.size()]));
                    }
                    this.controls.clear();
                    this.message = this.filter == null ? new LDAPSearchRequest(this.dn, this.scope, "", this.attributeNames.toArray(new String[this.attributeNames.size()]), this.searchCons.getDereference(), this.searchCons.getMaxResults(), this.searchCons.getServerTimeLimit(), this.typesOnly, this.searchCons.getControls()) : new LDAPSearchRequest(this.dn, this.scope, this.filter, this.attributeNames.toArray(new String[this.attributeNames.size()]), this.searchCons.getDereference(), this.searchCons.getMaxResults(), this.searchCons.getServerTimeLimit(), this.typesOnly, this.searchCons.getControls());
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    break;
                }
                case 12: {
                    this.state = 4;
                    break;
                }
                case 13: {
                    this.state = 12;
                    break;
                }
                case 2: {
                    this.state = 1;
                    break;
                }
                case 3: {
                    this.state = 1;
                    LDAPControl[] cons = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        cons = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPModifyRequest(this.dn, this.modlist.toArray(new LDAPModification[this.modlist.size()]), cons);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 29: {
                    LDAPAttribute at = new LDAPAttribute(this.attrName);
                    for (int i = 0; i < this.attributeValues.size(); ++i) {
                        at.addValue((byte[])this.attributeValues.get(i));
                    }
                    this.state = 3;
                    LDAPModification mod = new LDAPModification(this.operation, at);
                    this.modlist.add(mod);
                    break;
                }
                case 7: {
                    this.state = 1;
                    LDAPControl[] cons = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        cons = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPModifyDNRequest(this.dn, this.newRDN, this.newSuperior, this.deleteOldRDN, cons);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 5: {
                    this.state = 1;
                    this.entry = new LDAPEntry(this.dn, this.attrSet);
                    LDAPControl[] cons = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        cons = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPAddRequest(this.entry, cons);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 6: {
                    this.state = 1;
                    LDAPControl[] cons = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        cons = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPDeleteRequest(this.dn, cons);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 8: {
                    Object compareValue;
                    this.state = 1;
                    LDAPControl[] cons = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        cons = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = (compareValue = this.attributeValues.get(0)) instanceof byte[] ? new LDAPCompareRequest(this.dn, this.attrName, (byte[])compareValue, cons) : new LDAPCompareRequest(this.dn, this.attrName, ((String)compareValue).getBytes("UTF-8"), cons);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 10: {
                    this.state = 8;
                    break;
                }
                case 28: {
                    LDAPAttribute attr = this.attrSet.getAttribute(this.attrName);
                    if (attr == null) {
                        attr = new LDAPAttribute(this.attrName);
                        this.attrSet.add(attr);
                    }
                    int size = this.attributeValues.size();
                    for (int i = 0; i < size; ++i) {
                        Object addValue = this.attributeValues.get(i);
                        byte[] byteValue = addValue instanceof byte[] ? (byte[])addValue : ((String)addValue).getBytes("UTF8");
                        this.state = this.isAddRequest ? 5 : 41;
                        attr.addValue(byteValue);
                    }
                    break;
                }
                case 9: {
                    LDAPControl[] cons = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        cons = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPExtendedRequest(new LDAPExtendedOperation(this.requestName, this.requestValue), cons);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.state = 1;
                    this.controls.clear();
                    break;
                }
                case 30: {
                    this.state = 9;
                    this.requestName = this.value.toString();
                    break;
                }
                case 31: {
                    this.state = 9;
                    this.requestValue = Base64.decode(this.value, 0, this.value.length());
                    break;
                }
                case 14: {
                    this.state = 4;
                    break;
                }
                case 17: {
                    this.filter.endNestedFilter(2);
                    this.state = 14;
                    break;
                }
                case 15: {
                    this.filter.endNestedFilter(0);
                    this.state = 14;
                    break;
                }
                case 16: {
                    this.filter.endNestedFilter(1);
                    this.state = 14;
                    break;
                }
                case 18: {
                    if (this.state != 18) {
                        throw new SAXException("Unexpected tag: " + strSName);
                    }
                    this.filter.addAttributeValueAssertion(3, this.attrName, this.value.toString().getBytes("UTF-8"));
                    this.state = 14;
                    break;
                }
                case 22: {
                    if (this.state != 22) {
                        throw new SAXException("Unexpected tag: " + strSName);
                    }
                    this.filter.addPresent(this.attrName);
                    this.state = 14;
                    break;
                }
                case 20: {
                    if (this.state != 20) {
                        throw new SAXException("Unexpected tag: " + strSName);
                    }
                    this.filter.addAttributeValueAssertion(5, this.attrName, this.value.toString().getBytes("UTF-8"));
                    this.state = 14;
                    break;
                }
                case 21: {
                    if (this.state != 21) {
                        throw new SAXException("Unexpected tag: " + strSName);
                    }
                    this.filter.addAttributeValueAssertion(6, this.attrName, this.value.toString().getBytes("UTF-8"));
                    this.state = 14;
                    break;
                }
                case 23: {
                    if (this.state != 23) {
                        throw new SAXException("Unexpected tag: " + strSName);
                    }
                    this.filter.addAttributeValueAssertion(8, this.attrName, this.value.toString().getBytes("UTF-8"));
                    this.state = 14;
                    break;
                }
                case 24: {
                    if (this.state != 24) {
                        throw new SAXException("Unexpected tag: " + strSName);
                    }
                    this.filter.addExtensibleMatch(this.matchingRule, this.attrName, this.value.toString().getBytes("UTF-8"), this.isDNMatching);
                    this.state = 14;
                    break;
                }
                case 25: {
                    if (this.state != 25) {
                        throw new SAXException("Unexpected tag: " + strSName);
                    }
                    this.filter.addSubstring(0, this.value.toString().getBytes("UTF-8"));
                    this.state = 19;
                    break;
                }
                case 26: {
                    if (this.state != 26) {
                        throw new SAXException("Unexpected tag: " + strSName);
                    }
                    this.filter.addSubstring(1, this.value.toString().getBytes("UTF-8"));
                    this.state = 19;
                    break;
                }
                case 27: {
                    if (this.state != 27) {
                        throw new SAXException("Unexpected tag: " + strSName);
                    }
                    this.filter.addSubstring(2, this.value.toString().getBytes("UTF-8"));
                    this.state = 19;
                    break;
                }
                case 19: {
                    if (this.state != 27 && this.state != 19) {
                        throw new SAXException("Unexpected closing substring tag");
                    }
                    this.filter.endSubstrings();
                    this.state = 14;
                    break;
                }
                case 32: {
                    byte[] temp = this.isBase64 ? Base64.decode(this.value, 0, this.value.length()) : this.value.toString().getBytes("UTF-8");
                    this.controls.add(new LDAPControl(this.oid, this.critical, temp));
                    this.state = this.prevstate;
                    break;
                }
                case 11: {
                    this.state = this.valueState;
                    if (this.isBase64) {
                        this.attributeValues.add(Base64.decode(this.value, 0, this.value.length()));
                        break;
                    }
                    if (this.value == null) {
                        this.value = new StringBuffer();
                    }
                    this.attributeValues.add(this.value.toString().getBytes("UTF-8"));
                }
            }
        }
        catch (LDAPException e) {
            throw new SAXException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 encoding not supported:" + e);
        }
    }

    public void warning(SAXParseException e) throws SAXException {
    }

    public void error(SAXParseException e) throws SAXException {
        System.out.println("error: " + e.toString());
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.out.println("line : " + e.getLineNumber() + ", column : " + e.getColumnNumber());
        System.out.println("fatal error: " + e.toString());
        throw e;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    String getBatchRequestID() {
        return this.batchRequestID;
    }

    boolean isParallelProcessing() {
        return this.isParallel;
    }

    boolean isResponseUnordered() {
        return this.isUnordered;
    }

    boolean isResumeOnError() {
        return this.isResumeOnError;
    }

    ArrayList getQueue() {
        return this.queue;
    }

    ArrayList getErrors() {
        return this.errors;
    }

    static {
        requestTags.put("batchRequest", new Integer(1));
        requestTags.put("authRequest", new Integer(2));
        requestTags.put("modifyRequest", new Integer(3));
        requestTags.put("searchRequest", new Integer(4));
        requestTags.put("addRequest", new Integer(5));
        requestTags.put("delRequest", new Integer(6));
        requestTags.put("modDNRequest", new Integer(7));
        requestTags.put("compareRequest", new Integer(8));
        requestTags.put("extendedRequest", new Integer(9));
        requestTags.put("batchResponse", new Integer(34));
        requestTags.put("assertion", new Integer(10));
        requestTags.put("value", new Integer(11));
        requestTags.put("attributes", new Integer(12));
        requestTags.put("attribute", new Integer(13));
        requestTags.put("filter", new Integer(14));
        requestTags.put("and", new Integer(15));
        requestTags.put("or", new Integer(16));
        requestTags.put("not", new Integer(17));
        requestTags.put("equalityMatch", new Integer(18));
        requestTags.put("substrings", new Integer(19));
        requestTags.put("greaterOrEqual", new Integer(20));
        requestTags.put("lessOrEqual", new Integer(21));
        requestTags.put("present", new Integer(22));
        requestTags.put("approxMatch", new Integer(23));
        requestTags.put("extensibleMatch", new Integer(24));
        requestTags.put("attr", new Integer(28));
        requestTags.put("modification", new Integer(29));
        requestTags.put("requestName", new Integer(30));
        requestTags.put("requestValue", new Integer(31));
        requestTags.put("initial", new Integer(25));
        requestTags.put("any", new Integer(26));
        requestTags.put("final", new Integer(27));
        requestTags.put("control", new Integer(32));
        requestTags.put("controlValue", new Integer(11));
        requestTags.put("addResponse", new Integer(35));
        requestTags.put("resultCode", new Integer(37));
        requestTags.put("errorMessage", new Integer(38));
        requestTags.put("message", new Integer(54));
        requestTags.put("errorResponse", new Integer(53));
        requestTags.put("referral", new Integer(39));
        requestTags.put("searchResponse", new Integer(40));
        requestTags.put("searchResultEntry", new Integer(41));
        requestTags.put("searchResultReference", new Integer(42));
        requestTags.put("ref", new Integer(43));
        requestTags.put("searchResultDone", new Integer(44));
        requestTags.put("authResponse", new Integer(48));
        requestTags.put("modifyResponse", new Integer(49));
        requestTags.put("delResponse", new Integer(50));
        requestTags.put("modDNResponse", new Integer(51));
        requestTags.put("compareResponse", new Integer(52));
        requestTags.put("extendedResponse", new Integer(45));
        requestTags.put("responseName", new Integer(46));
        requestTags.put("response", new Integer(47));
    }
}

