/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPDITStructureRuleSchema
extends LDAPSchemaElement {
    private int ruleID = 0;
    private String nameForm = "";
    private String[] superiorIDs = new String[]{""};

    public LDAPDITStructureRuleSchema() {
        super(LDAPSchema.schemaTypeNames[5]);
    }

    public LDAPDITStructureRuleSchema(String[] stringArray, int n, String string, boolean bl, String string2, String[] stringArray2) {
        super(LDAPSchema.schemaTypeNames[5]);
        this.names = (String[])stringArray.clone();
        this.ruleID = n;
        this.description = string;
        this.obsolete = bl;
        this.nameForm = string2;
        this.superiorIDs = stringArray2;
        super.setValue(this.formatString());
    }

    public LDAPDITStructureRuleSchema(String string) {
        super(LDAPSchema.schemaTypeNames[5]);
        this.obsolete = false;
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getNames() != null) {
                this.names = (String[])schemaParser.getNames().clone();
            }
            if (schemaParser.getID() != null) {
                this.ruleID = Integer.parseInt(schemaParser.getID());
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            if (schemaParser.getSuperiors() != null) {
                this.superiorIDs = (String[])schemaParser.getSuperiors().clone();
            }
            if (schemaParser.getNameForm() != null) {
                this.nameForm = schemaParser.getNameForm();
            }
            this.obsolete = schemaParser.getObsolete();
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public String getNameForm() {
        return this.nameForm;
    }

    public String[] getSuperiors() {
        return this.superiorIDs;
    }

    protected String formatString() {
        Enumeration enumeration;
        int n;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = String.valueOf(this.getRuleID());
        stringBuffer.append(string);
        String[] stringArray = this.getNames();
        if (stringArray != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((string = this.getNameForm()) != null) {
            stringBuffer.append(" FORM ");
            stringBuffer.append("'" + string + "'");
        }
        if ((stringArray = this.getSuperiors()) != null) {
            stringBuffer.append(" SUP ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((enumeration = this.getQualifierNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                stringBuffer.append(" " + string2 + " ");
                String[] stringArray2 = this.getQualifier(string2);
                if (stringArray2 == null) continue;
                if (stringArray2.length > 1) {
                    stringBuffer.append("( ");
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("'" + stringArray2[i] + "'");
                }
                if (stringArray2.length <= 1) continue;
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream bufferedInputStream) throws IOException {
        LDAPDITStructureRuleSchema lDAPDITStructureRuleSchema = (LDAPDITStructureRuleSchema)LDAPDITStructureRuleSchema.readDSML(bufferedInputStream);
        this.oid = lDAPDITStructureRuleSchema.getID();
        this.names = lDAPDITStructureRuleSchema.getNames();
        this.description = lDAPDITStructureRuleSchema.getDescription();
        this.obsolete = lDAPDITStructureRuleSchema.isObsolete();
        Enumeration enumeration = lDAPDITStructureRuleSchema.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = lDAPDITStructureRuleSchema.getQualifier(string);
            this.setQualifier(string, stringArray);
        }
        super.setValue(this.formatString());
        this.ruleID = lDAPDITStructureRuleSchema.getRuleID();
        this.nameForm = lDAPDITStructureRuleSchema.getName();
        this.superiorIDs = lDAPDITStructureRuleSchema.getSuperiors();
        lDAPDITStructureRuleSchema = null;
    }

    protected void writeValue(Writer writer) throws IOException {
        String string = this.formatString();
        writer.write(ValueXMLhandler.newLine(2));
        writer.write("<value>");
        writer.write(string);
        writer.write("</value>");
    }

    protected void writeValue(StringBuffer stringBuffer) {
        String string = this.formatString();
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("<value>");
        stringBuffer.append(string);
        stringBuffer.append("</value>");
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPDITStructureRuleSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPDITStructureRuleSchema)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPDITStructureRuleSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPDITStructureRuleSchema)this.valuelist.get(0));
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator iterator = this.valuelist.iterator();
                LDAPDITStructureRuleSchema lDAPDITStructureRuleSchema = new LDAPDITStructureRuleSchema(this.attrName);
                byte[] byArray = (byte[])iterator.next();
                StringBuffer stringBuffer = new StringBuffer(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
                try {
                    SchemaParser schemaParser = new SchemaParser(stringBuffer.toString());
                    if (schemaParser.getNames() != null) {
                        lDAPDITStructureRuleSchema.names = (String[])schemaParser.getNames().clone();
                    }
                    if (schemaParser.getID() != null) {
                        lDAPDITStructureRuleSchema.ruleID = Integer.parseInt(schemaParser.getID());
                    }
                    if (schemaParser.getDescription() != null) {
                        lDAPDITStructureRuleSchema.description = schemaParser.getDescription();
                    }
                    if (schemaParser.getSuperiors() != null) {
                        LDAPDITStructureRuleSchema.access$102(lDAPDITStructureRuleSchema, (String[])schemaParser.getSuperiors().clone());
                    }
                    if (schemaParser.getNameForm() != null) {
                        lDAPDITStructureRuleSchema.nameForm = schemaParser.getNameForm();
                    }
                    lDAPDITStructureRuleSchema.obsolete = schemaParser.getObsolete();
                    Enumeration enumeration = schemaParser.getQualifiers();
                    while (enumeration.hasMoreElements()) {
                        AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                        lDAPDITStructureRuleSchema.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
                    }
                    lDAPDITStructureRuleSchema.setValue(lDAPDITStructureRuleSchema.formatString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
                this.setObject(lDAPDITStructureRuleSchema);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    static /* synthetic */ String[] access$102(LDAPDITStructureRuleSchema lDAPDITStructureRuleSchema, String[] stringArray) {
        lDAPDITStructureRuleSchema.superiorIDs = stringArray;
        return stringArray;
    }
}

