/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.EnumeratedIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;

public abstract class LDAPSchemaElement
extends LDAPAttribute
implements Serializable {
    protected String[] names = new String[]{""};
    protected String oid = "";
    protected String description = "";
    protected boolean obsolete = false;
    protected String[] qualifier = new String[]{""};
    protected HashMap hashQualifier = new HashMap();

    protected LDAPSchemaElement(String string) {
        super(string);
    }

    public String[] getNames() {
        if (this.names == null) {
            return null;
        }
        return (String[])this.names.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.oid;
    }

    public String[] getQualifier(String string) {
        AttributeQualifier attributeQualifier = (AttributeQualifier)this.hashQualifier.get(string);
        if (attributeQualifier != null) {
            return attributeQualifier.getValues();
        }
        return null;
    }

    public Enumeration getQualifierNames() {
        return new EnumeratedIterator(this.hashQualifier.keySet().iterator());
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public String toString() {
        return this.formatString();
    }

    protected abstract String formatString();

    public void setQualifier(String string, String[] stringArray) {
        AttributeQualifier attributeQualifier = new AttributeQualifier(string, stringArray);
        this.hashQualifier.put(string, attributeQualifier);
        super.setValue(this.formatString());
    }

    public void addValue(String string) {
        throw new UnsupportedOperationException("addValue is not supported by LDAPSchemaElement");
    }

    public void addValue(Byte[] byteArray) {
        throw new UnsupportedOperationException("addValue is not supported by LDAPSchemaElement");
    }

    public void removeValue(String string) {
        throw new UnsupportedOperationException("removeValue is not supported by LDAPSchemaElement");
    }

    public void removeValue(Byte[] byteArray) {
        throw new UnsupportedOperationException("removeValue is not supported by LDAPSchemaElement");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

