/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ModuleStateEventData
implements EventResponseData {
    private final String connectionDN;
    private final int flags;
    private final String name;
    private final String description;
    private final String source;

    public ModuleStateEventData(ASN1Object aSN1Object) throws IOException {
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int[] nArray = new int[1];
        this.connectionDN = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.flags = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.name = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.description = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.source = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
    }

    public String getConnectionDN() {
        return this.connectionDN;
    }

    public String getDescription() {
        return this.description;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ModuleStateEvent[connectionDN=" + this.getConnectionDN() + "]");
        stringBuffer.append("[flags=" + this.getFlags() + "]");
        stringBuffer.append("[Name=" + this.getName() + "]");
        stringBuffer.append("[Description=" + this.getDescription() + "]");
        stringBuffer.append("[Source=" + this.getSource() + "]]");
        return stringBuffer.toString();
    }
}

