/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class GetReplicationFilterResponse
extends LDAPExtendedResponse {
    String[][] returnedFilter;

    public GetReplicationFilterResponse(RfcLDAPMessage rfcLDAPMessage) throws IOException {
        super(rfcLDAPMessage);
        if (this.getResultCode() != 0) {
            this.returnedFilter = new String[0][0];
        } else {
            byte[] byArray = this.getValue();
            if (byArray == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder lBERDecoder = new LBERDecoder();
            if (lBERDecoder == null) {
                throw new IOException("Decoding error");
            }
            ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
            if (aSN1Sequence == null) {
                throw new IOException("Decoding error");
            }
            int n = aSN1Sequence.size();
            this.returnedFilter = new String[n][];
            for (int i = 0; i < n; ++i) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(i);
                if (aSN1Sequence2 == null) {
                    throw new IOException("Decoding error");
                }
                ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence2.get(0);
                if (aSN1OctetString == null) {
                    return;
                }
                ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence2.get(1);
                if (aSN1Sequence3 == null) {
                    throw new IOException("Decoding error");
                }
                int n2 = aSN1Sequence3.size();
                this.returnedFilter[i] = new String[n2 + 1];
                this.returnedFilter[i][0] = aSN1OctetString.stringValue();
                if (this.returnedFilter[i][0] == null) {
                    throw new IOException("Decoding error");
                }
                for (int j = 0; j < n2; ++j) {
                    ASN1OctetString aSN1OctetString2 = (ASN1OctetString)aSN1Sequence3.get(j);
                    if (aSN1OctetString2 == null) {
                        throw new IOException("Decoding error");
                    }
                    this.returnedFilter[i][j + 1] = aSN1OctetString2.stringValue();
                    if (this.returnedFilter[i][j + 1] != null) continue;
                    throw new IOException("Decoding error");
                }
            }
        }
    }

    public String[][] getReplicationFilter() {
        return this.returnedFilter;
    }
}

