/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.util.DN;
import java.util.ArrayList;
import java.util.Vector;

public class RDN {
    private ArrayList types;
    private ArrayList values;
    private String rawValue;

    public RDN(String string) {
        this.rawValue = string;
        DN dN = new DN(string);
        Vector vector = dN.getRDNs();
        if (vector.size() != 1) {
            throw new IllegalArgumentException("Invalid RDN: see API documentation");
        }
        RDN rDN = (RDN)vector.elementAt(0);
        this.types = rDN.types;
        this.values = rDN.values;
        this.rawValue = rDN.rawValue;
    }

    public RDN() {
        this.types = new ArrayList();
        this.values = new ArrayList();
        this.rawValue = "";
    }

    public boolean equals(RDN rDN) {
        if (this.values.size() != rDN.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            int n;
            for (n = 0; !(n >= this.values.size() || ((String)this.values.get(i)).equalsIgnoreCase((String)rDN.values.get(n)) && this.equalAttrType((String)this.types.get(i), (String)rDN.types.get(n))); ++n) {
            }
            if (n < rDN.values.size()) continue;
            return false;
        }
        return true;
    }

    private boolean equalAttrType(String string, String string2) {
        if (Character.isDigit(string.charAt(0)) ^ Character.isDigit(string2.charAt(0))) {
            throw new IllegalArgumentException("OID numbers are not currently compared to attribute names");
        }
        return string.equalsIgnoreCase(string2);
    }

    protected String getRawValue() {
        return this.rawValue;
    }

    public void add(String string, String string2, String string3) {
        this.types.add(string);
        this.values.add(string2);
        this.rawValue = this.rawValue + string3;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        int n = this.types.size();
        String string = "";
        if (n < 1) {
            return null;
        }
        if (!bl) {
            string = this.types.get(0) + "=";
        }
        string = string + this.values.get(0);
        for (int i = 1; i < n; ++i) {
            string = string + "+";
            if (!bl) {
                string = string + this.types.get(i) + "=";
            }
            string = string + this.values.get(i);
        }
        return string;
    }

    public String[] explodeRDN(boolean bl) {
        int n = this.types.size();
        if (n < 1) {
            return null;
        }
        String[] stringArray = new String[this.types.size()];
        if (!bl) {
            stringArray[0] = this.types.get(0) + "=";
        }
        stringArray[0] = stringArray[0] + this.values.get(0);
        for (int i = 1; i < n; ++i) {
            if (!bl) {
                int n2 = i;
                stringArray[n2] = stringArray[n2] + this.types.get(i) + "=";
            }
            int n3 = i;
            stringArray[n3] = stringArray[n3] + this.values.get(i);
        }
        return stringArray;
    }

    public String getType() {
        return (String)this.types.get(0);
    }

    public String[] getTypes() {
        String[] stringArray = new String[this.types.size()];
        for (int i = 0; i < this.types.size(); ++i) {
            stringArray[i] = (String)this.types.get(i);
        }
        return stringArray;
    }

    public String getValue() {
        return (String)this.values.get(0);
    }

    public String[] getValues() {
        String[] stringArray = new String[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            stringArray[i] = (String)this.values.get(i);
        }
        return stringArray;
    }

    public boolean isMultivalued() {
        return this.values.size() > 1;
    }
}

