/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.mapping;

import com.ocpsoft.pretty.faces.config.mapping.RequestParameter;
import com.ocpsoft.pretty.faces.el.PrettyExpression;

public class PathParameter
extends RequestParameter {
    private static final String PATH_PARAM_NAME_PREFIX = "com.ocpsoft.vP_";
    private static final String DEFAULT_PATH_REGEX = "[^/]+";
    private int position;
    private String regex = "[^/]+";
    private boolean expressionIsPlainText = true;

    public PathParameter() {
    }

    public PathParameter(String name, String value, PrettyExpression expression) {
        super(name, value, expression);
    }

    public PathParameter(String name, String value) {
        super(name, value);
    }

    public PathParameter copy() {
        PathParameter result = new PathParameter();
        if (this.isNamed()) {
            result.setName(this.getName());
        }
        result.setName(this.getName());
        result.setValue(this.getValue());
        result.setPosition(this.getPosition());
        result.setExpression(this.getExpression());
        result.setRegex(this.getRegex());
        result.setExpressionIsPlainText(this.expressionIsPlainText());
        return result;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int param) {
        this.position = param;
    }

    public boolean isNamed() {
        return null != super.getName() && !"".equals(super.getName().trim());
    }

    public String getName() {
        if (!this.isNamed()) {
            return PATH_PARAM_NAME_PREFIX + this.getPosition();
        }
        return super.getName();
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setExpressionIsPlainText(boolean value) {
        this.expressionIsPlainText = value;
    }

    public boolean expressionIsPlainText() {
        return this.expressionIsPlainText;
    }

    public String toString() {
        return "PathParameter [position=" + this.position + ", regex=" + this.regex + ", name=" + this.getName() + ", expression=" + this.getExpression() + ", value=" + this.getValue() + "]";
    }
}

