/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.spi;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.PathValidator;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.spi.ConfigurationPostProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public class ParentingPostProcessor
implements ConfigurationPostProcessor {
    public static final String HIERARCHY_ENABLED_PARAM = "com.ocpsoft.pretty.INHERITABLE_CONFIG";
    private final List<UrlMapping> seen = new ArrayList<UrlMapping>();

    public PrettyConfig processConfiguration(ServletContext context, PrettyConfig config) {
        String enabled = context.getInitParameter(HIERARCHY_ENABLED_PARAM);
        if (enabled != null && "false".equalsIgnoreCase(enabled.trim())) {
            return config;
        }
        List<UrlMapping> mappings = config.getMappings();
        for (UrlMapping m : mappings) {
            this.createAncestry(config, m);
        }
        return config;
    }

    private void createAncestry(PrettyConfig config, UrlMapping m) {
        if (m.hasParent() && !this.seen.contains(m)) {
            UrlMapping parent = config.getMappingById(m.getParentId());
            if (parent == null) {
                throw new PrettyException("Error when building configuration for URL-mapping [" + m.getId() + ":" + m.getPattern() + "] - the requested parentId [" + m.getParentId() + "] does not exist in the configuration.");
            }
            if (parent.hasParent()) {
                this.createAncestry(config, parent);
            }
            m.setPattern(parent.getPattern() + m.getPattern());
            this.mergeValidators(parent, m);
            this.seen.add(m);
        }
    }

    private void mergeValidators(UrlMapping parent, UrlMapping child) {
        ArrayList<PathValidator> result = new ArrayList<PathValidator>();
        ArrayList<PathValidator> validators = new ArrayList<PathValidator>();
        validators.addAll(parent.getPathValidators());
        validators.addAll(child.getPathValidators());
        int i = 0;
        for (PathValidator pv : validators) {
            PathValidator temp = this.copy(pv);
            temp.setIndex(i++);
            result.add(temp);
        }
        child.setPathValidators(result);
    }

    private PathValidator copy(PathValidator pathValidator) {
        PathValidator result = new PathValidator();
        result.setIndex(pathValidator.getIndex());
        result.setOnError(pathValidator.getOnError());
        result.setValidatorIds(pathValidator.getValidatorIds());
        result.setValidatorExpression(pathValidator.getValidatorExpression());
        return result;
    }
}

