/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el.resolver;

import com.ocpsoft.pretty.faces.spi.ELBeanNameResolver;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIBeanNameResolver
implements ELBeanNameResolver {
    private static final Log log = LogFactory.getLog(CDIBeanNameResolver.class);
    public static final String BEAN_MANAGER_JNDI = "java:comp/BeanManager";
    public static final String BEAN_MANAGER_JNDI_TOMCAT = "java:comp/env/BeanManager";
    public static final String SERVLET_CONTEXT_ATTR_WELD_1_1 = "org.jboss.weld.environment.servlet.javax.enterprise.inject.spi.BeanManager";
    public static final String BEAN_MANAGER_CLASS = "javax.enterprise.inject.spi.BeanManager";
    public static final String GET_BEANS_METHOD = "getBeans";
    private static final String BEAN_CLASS = "javax.enterprise.inject.spi.Bean";
    public static final String GET_NAME_METHOD = "getName";
    private Method getBeansMethod = null;
    private Method getNameMethod = null;
    private Object beanManager;

    @Override
    public boolean init(ServletContext servletContext, ClassLoader classLoader) {
        try {
            Class<?> beanManagerClass = classLoader.loadClass(BEAN_MANAGER_CLASS);
            this.getBeansMethod = beanManagerClass.getMethod(GET_BEANS_METHOD, Type.class, Annotation[].class);
            Class<?> beanClass = classLoader.loadClass(BEAN_CLASS);
            this.getNameMethod = beanClass.getMethod(GET_NAME_METHOD, new Class[0]);
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("BeanManager or Bean class not found. CDI resolver has been disabled.");
            }
            return false;
        }
        catch (NoSuchMethodException e) {
            log.warn("Cannot find BeanManager.getBeans() or Bean.getName() method", e);
            return false;
        }
        catch (SecurityException e) {
            log.warn("Unable to init resolver due to security restrictions", e);
            return false;
        }
        this.beanManager = this.getBeanManagerFromServletContext(servletContext, BEAN_MANAGER_CLASS);
        if (this.beanManager == null) {
            this.beanManager = this.getBeanManagerFromServletContext(servletContext, SERVLET_CONTEXT_ATTR_WELD_1_1);
        }
        if (this.beanManager == null) {
            this.beanManager = this.getBeanManagerFromJNDI(BEAN_MANAGER_JNDI);
        }
        if (this.beanManager == null) {
            this.beanManager = this.getBeanManagerFromJNDI(BEAN_MANAGER_JNDI_TOMCAT);
        }
        if (this.beanManager == null) {
            if (log.isDebugEnabled()) {
                log.debug("BeanManager cannot be found! CDI resolver gets disabled!");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("CDI environment detected. Enabling bean name resolving via BeanManager.");
        }
        return true;
    }

    private Object getBeanManagerFromServletContext(ServletContext servletContext, String attributeName) {
        Object obj = servletContext.getAttribute(attributeName);
        if (log.isTraceEnabled()) {
            if (obj == null) {
                log.trace("The BeanManager could not be found in servlet context attribute: " + attributeName);
            } else {
                log.trace("Found BeanManager in the servlet context attribute: " + attributeName);
            }
        }
        return obj;
    }

    private Object getBeanManagerFromJNDI(String jndiName) {
        try {
            InitialContext initialContext = new InitialContext();
            Object obj = initialContext.lookup(jndiName);
            if (log.isTraceEnabled()) {
                log.trace("Found BeanManager in: " + jndiName);
            }
            return obj;
        }
        catch (NamingException e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to get BeanManager from '" + jndiName + "': " + e.getMessage());
            }
            return null;
        }
    }

    @Override
    public String getBeanName(Class<?> clazz) {
        try {
            Set beansSet = (Set)this.getBeansMethod.invoke(this.beanManager, clazz, Array.newInstance(Annotation.class, 0));
            if (beansSet == null || beansSet.size() == 0) {
                if (log.isTraceEnabled()) {
                    log.trace("BeanManager doesn't know  class: " + clazz.getName());
                }
                return null;
            }
            if (beansSet.size() > 1) {
                log.warn("The BeanManager returns more than one name for " + clazz.getName() + ". You should place a @URLBeanName annotation on the class.");
                return null;
            }
            Object bean = beansSet.iterator().next();
            String name = (String)this.getNameMethod.invoke(bean, new Object[0]);
            if (log.isTraceEnabled()) {
                log.trace("BeanManager returned name " + name + " for class: " + clazz.getName());
            }
            return name;
        }
        catch (IllegalAccessException e) {
            log.warn("Unable to access BeanManager due to security restrictions", e);
        }
        catch (InvocationTargetException e) {
            log.error("Failed to query BeanManager for the bean name...", e);
        }
        return null;
    }
}

