/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.component.renderer;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.component.UrlBuffer;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.util.PrettyURLBuilder;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;

public class UrlBufferRenderer
extends Renderer {
    public static final String RENDERER_TYPE = "com.ocpsoft.pretty.Url";
    private final PrettyURLBuilder urlBuilder = new PrettyURLBuilder();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        if (!component.isRendered()) {
            return;
        }
        UrlBuffer urlBuffer = (UrlBuffer)component;
        String var = (String)urlBuffer.getAttributes().get("var");
        String mappingId = (String)component.getAttributes().get("mappingId");
        if (mappingId == null) {
            throw new PrettyException("Mapping id was null when attempting to build URL for component: " + component.toString() + " <" + component.getClientId(context) + ">");
        }
        PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
        PrettyConfig prettyConfig = prettyContext.getConfig();
        UrlMapping urlMapping = prettyConfig.getMappingById(mappingId);
        String href = context.getExternalContext().getRequestContextPath() + this.urlBuilder.build(urlMapping, true, this.urlBuilder.extractParameters(component));
        context.getExternalContext().getRequestMap().put(var, href);
    }
}

