/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.net.UrlEscapers;
import com.offbytwo.jenkins.client.JenkinsHttpClient;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.Computer;
import com.offbytwo.jenkins.model.ComputerSet;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobConfiguration;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.LabelWithDetails;
import com.offbytwo.jenkins.model.MainView;
import com.offbytwo.jenkins.model.MavenJobWithDetails;
import com.offbytwo.jenkins.model.QueueItem;
import com.offbytwo.jenkins.model.QueueReference;
import com.offbytwo.jenkins.model.View;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.ContentType;
import org.dom4j.DocumentException;

public class JenkinsServer {
    private final JenkinsHttpClient client;

    public JenkinsServer(URI serverUri) {
        this(new JenkinsHttpClient(serverUri));
    }

    public JenkinsServer(URI serverUri, String username, String passwordOrToken) {
        this(new JenkinsHttpClient(serverUri, username, passwordOrToken));
    }

    public JenkinsServer(JenkinsHttpClient client) {
        this.client = client;
    }

    public boolean isRunning() {
        try {
            this.client.get("/");
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Map<String, Job> getJobs() throws IOException {
        List<Job> jobs = this.client.get("/", MainView.class).getJobs();
        return Maps.uniqueIndex(jobs, (Function)new Function<Job, String>(){

            public String apply(Job job) {
                job.setClient(JenkinsServer.this.client);
                return job.getName().toLowerCase();
            }
        });
    }

    public Map<String, View> getViews() throws IOException {
        List<View> views = this.client.get("/", MainView.class).getViews();
        return Maps.uniqueIndex(views, (Function)new Function<View, String>(){

            public String apply(View view) {
                view.setClient(JenkinsServer.this.client);
                return view.getName();
            }
        });
    }

    public View getView(String name) throws IOException {
        return this.client.get("/view/" + this.encode(name) + "/", View.class);
    }

    public Map<String, Job> getJobs(String view) throws IOException {
        List<Job> jobs = this.client.get("/view/" + this.encode(view) + "/", View.class).getJobs();
        return Maps.uniqueIndex(jobs, (Function)new Function<Job, String>(){

            public String apply(Job job) {
                job.setClient(JenkinsServer.this.client);
                return job.getName().toLowerCase();
            }
        });
    }

    public JobWithDetails getJob(String jobName) throws IOException {
        try {
            JobWithDetails job = this.client.get("/job/" + this.encode(jobName), JobWithDetails.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public MavenJobWithDetails getMavenJob(String jobName) throws IOException {
        try {
            MavenJobWithDetails job = this.client.get("/job/" + this.encode(jobName), MavenJobWithDetails.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public void createJob(String jobName, String jobXml) throws IOException {
        this.client.post_xml("/createItem?name=" + this.encodeParam(jobName), jobXml);
    }

    public void createJob(String jobName, String jobXml, Boolean crumbFlag) throws IOException {
        this.client.post_xml("/createItem?name=" + this.encodeParam(jobName), jobXml, crumbFlag);
    }

    public String getJobXml(String jobName) throws IOException {
        return this.client.get("/job/" + this.encode(jobName) + "/config.xml");
    }

    public LabelWithDetails getLabel(String labelName) throws IOException {
        return this.client.get("/label/" + this.encode(labelName), LabelWithDetails.class);
    }

    public Map<String, Computer> getComputers() throws IOException {
        List<Computer> computers = this.client.get("computer/", Computer.class).getComputers();
        return Maps.uniqueIndex(computers, (Function)new Function<Computer, String>(){

            public String apply(Computer computer) {
                computer.setClient(JenkinsServer.this.client);
                return computer.getDisplayName().toLowerCase();
            }
        });
    }

    public ComputerSet getComputerSet() throws IOException {
        return this.client.get("computer/", ComputerSet.class);
    }

    public void updateJob(String jobName, String jobXml) throws IOException {
        this.updateJob(jobName, jobXml, true);
    }

    public void updateJob(String jobName, String jobXml, boolean crumbFlag) throws IOException {
        this.client.post_xml("/job/" + this.encode(jobName) + "/config.xml", jobXml, crumbFlag);
    }

    public void addStringParam(String jobName, String name, String description, String defaultValue) throws IOException, JAXBException, DocumentException {
        String jobXml = this.getJobXml(jobName);
        JobConfiguration jobConf = new JobConfiguration(jobXml);
        jobXml = jobConf.addStringParam(name, description, defaultValue).asXml();
        this.updateJob(jobName, jobXml);
    }

    public void quietDown() throws IOException {
        try {
            this.client.get("/quietDown/");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
    }

    public void cancelQuietDown() throws IOException {
        try {
            this.client.post("/cancelQuietDown/");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
    }

    public void deleteJob(String jobName) throws IOException {
        this.client.post("/job/" + this.encode(jobName) + "/doDelete");
    }

    public void deleteJob(String jobName, boolean crumbFlag) throws IOException {
        this.client.post("/job/" + this.encode(jobName) + "/doDelete", crumbFlag);
    }

    public String runScript(String script) throws IOException {
        return this.client.post_text("/scriptText", "script=" + script, ContentType.APPLICATION_FORM_URLENCODED, false);
    }

    private String encode(String pathPart) {
        String escape = UrlEscapers.urlPathSegmentEscaper().escape(pathPart);
        return escape;
    }

    private String encodeParam(String pathPart) {
        return UrlEscapers.urlFormParameterEscaper().escape(pathPart);
    }

    public QueueItem getQueueItem(QueueReference ref) throws IOException {
        try {
            String url = ref.getQueueItemUrlPart();
            QueueItem job = this.client.get(url, QueueItem.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public Build getBuild(QueueItem q) throws IOException {
        try {
            String url = q.getExecutable().getUrl();
            Build job = this.client.get(url, Build.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }
}

