/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.infra.jmx;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.infra.eventbridge.TCKEventBroadcaster;
import com.opencloud.sleetck.lib.infra.jmx.MBeanFacadeAgentRemote;
import com.opencloud.sleetck.lib.infra.jmx.NotificationListenerID;
import com.opencloud.sleetck.lib.infra.jmx.NotificationListenerProxy;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class MBeanFacadeAgentRemoteImpl
extends UnicastRemoteObject
implements MBeanFacadeAgentRemote {
    private MBeanServer server;
    private TCKEventBroadcaster broadcaster;
    private Map notificationListeners = new HashMap();
    private Map listenerSources = new HashMap();
    private static final boolean _DEBUG_ = false;

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.server = mBeanServer;
    }

    public void setEventBroadcaster(TCKEventBroadcaster tCKEventBroadcaster) {
        this.broadcaster = tCKEventBroadcaster;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, TCKTestErrorException {
        this.assertServer();
        return this.server.createMBean(string, objectName);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, TCKTestErrorException {
        this.assertServer();
        return this.server.createMBean(string, objectName, objectName2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, TCKTestErrorException {
        this.assertServer();
        return this.server.createMBean(string, objectName, objectArray, stringArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, TCKTestErrorException {
        this.assertServer();
        return this.server.createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, TCKTestErrorException {
        this.assertServer();
        this.server.unregisterMBean(objectName);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, TCKTestErrorException {
        this.assertServer();
        return this.server.getObjectInstance(objectName);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws TCKTestErrorException {
        this.assertServer();
        return this.server.queryMBeans(objectName, queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws TCKTestErrorException {
        this.assertServer();
        return this.server.queryNames(objectName, queryExp);
    }

    public boolean isRegistered(ObjectName objectName) throws TCKTestErrorException {
        this.assertServer();
        return this.server.isRegistered(objectName);
    }

    public Integer getMBeanCount() throws TCKTestErrorException {
        this.assertServer();
        return this.server.getMBeanCount();
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, TCKTestErrorException {
        this.assertServer();
        return this.server.getAttribute(objectName, string);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, TCKTestErrorException {
        this.assertServer();
        return this.server.getAttributes(objectName, stringArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, TCKTestErrorException {
        this.assertServer();
        this.server.setAttribute(objectName, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, TCKTestErrorException {
        this.assertServer();
        return this.server.setAttributes(objectName, attributeList);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, TCKTestErrorException {
        this.assertServer();
        Object object = this.server.invoke(objectName, string, objectArray, stringArray);
        if (object == Void.TYPE) {
            object = null;
        }
        return object;
    }

    public String getDefaultDomain() throws TCKTestErrorException {
        this.assertServer();
        return this.server.getDefaultDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotificationListener(NotificationListenerID notificationListenerID, ObjectName objectName, NotificationFilter notificationFilter) throws InstanceNotFoundException, RemoteException, TCKTestErrorException {
        this.assertServer();
        if (this.broadcaster == null) {
            throw new TCKTestErrorException("The operation failed because the event broadcaster reference was not set in the JMX agent.");
        }
        NotificationListenerProxy notificationListenerProxy = new NotificationListenerProxy(this.broadcaster);
        Map map = this.notificationListeners;
        synchronized (map) {
            this.server.addNotificationListener(objectName, notificationListenerProxy, notificationFilter, (Object)notificationListenerID);
            this.notificationListeners.put(notificationListenerID, notificationListenerProxy);
            this.listenerSources.put(notificationListenerID, objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterNotificationListener(NotificationListenerID notificationListenerID, ObjectName objectName) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException, TCKTestErrorException {
        this.assertServer();
        NotificationListener notificationListener = null;
        Map map = this.notificationListeners;
        synchronized (map) {
            notificationListener = (NotificationListener)this.notificationListeners.remove(notificationListenerID);
            this.listenerSources.remove(notificationListenerID);
        }
        if (notificationListener != null) {
            this.server.removeNotificationListener(objectName, notificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAllNotificationListeners() throws RemoteException, TCKTestErrorException {
        this.assertServer();
        Map map = this.notificationListeners;
        synchronized (map) {
            Map map2 = this.copyMap(this.listenerSources);
            for (NotificationListenerID notificationListenerID : map2.keySet()) {
                ObjectName objectName = (ObjectName)map2.get(notificationListenerID);
                try {
                    this.deregisterNotificationListener(notificationListenerID, objectName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    this.debug("WARNING: MBeanFacadeAgentRemoteImpl.deregisterAllNotificationListeners(): caught exception while deregistering listener of id " + notificationListenerID + ":" + instanceNotFoundException);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    this.debug("WARNING: MBeanFacadeAgentRemoteImpl.deregisterAllNotificationListeners(): caught exception while deregistering listener of id " + notificationListenerID + ":" + listenerNotFoundException);
                }
            }
        }
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, TCKTestErrorException {
        this.assertServer();
        this.server.addNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException, TCKTestErrorException {
        this.assertServer();
        this.server.removeNotificationListener(objectName, objectName2);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, TCKTestErrorException {
        this.assertServer();
        return this.server.getMBeanInfo(objectName);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, TCKTestErrorException {
        this.assertServer();
        return this.server.isInstanceOf(objectName, string);
    }

    private void assertServer() throws TCKTestErrorException {
        if (this.server == null) {
            throw new TCKTestErrorException("The operation failed because the MBeanServer reference was not set in the JMX agent.");
        }
    }

    private Map copyMap(Map map) {
        HashMap hashMap = new HashMap();
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            hashMap.put(k, v);
        }
        return hashMap;
    }

    private void debug(String string) {
        System.err.println(string);
    }
}

