/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.sbbutils;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKResourceAdaptorSbbInterface;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKResourceSbbInterface;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ComponentID;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.Level;
import javax.slee.facilities.TraceFacility;

public class TCKSbbUtils {
    public static TCKResourceAdaptorSbbInterface getResourceAdaptorInterface() throws NamingException {
        return (TCKResourceAdaptorSbbInterface)TCKSbbUtils.getSbbEnvironment().lookup("slee/resources/tck/resource");
    }

    public static TCKResourceSbbInterface getResourceInterface() throws NamingException {
        return TCKSbbUtils.getResourceAdaptorInterface().getResource();
    }

    public static Context getSbbEnvironment() throws NamingException {
        InitialContext initialContext = new InitialContext();
        return (Context)initialContext.lookup("java:comp/env");
    }

    public static void handleException(Exception exception) {
        try {
            TCKSbbUtils.getResourceInterface().sendException(exception);
        }
        catch (Exception exception2) {
            exception.printStackTrace();
            exception2.printStackTrace();
        }
    }

    public static void createAlarm(ComponentID componentID, Level level, String string, Throwable throwable) throws TCKTestErrorException {
        try {
            AlarmFacility alarmFacility = (AlarmFacility)TCKSbbUtils.getSbbEnvironment().lookup("slee/facilities/alarm");
            alarmFacility.createAlarm(componentID, level, "sbb.tck.message", string, throwable, System.currentTimeMillis());
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Caught Exception while trying to send an alarm:" + exception + ". Alarm message: " + string);
        }
    }

    public static void createTrace(ComponentID componentID, Level level, String string, Throwable throwable) throws TCKTestErrorException {
        try {
            TraceFacility traceFacility = (TraceFacility)TCKSbbUtils.getSbbEnvironment().lookup("slee/facilities/trace");
            traceFacility.createTrace(componentID, level, "sbb.tck.message", string, throwable, System.currentTimeMillis());
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Caught Exception while trying to send a trace message:" + exception + ". Trace message: " + string);
        }
    }
}

