/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.concurrency;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEvent;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventY;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import javax.slee.ActivityContextInterface;
import javax.slee.RolledBackContext;
import javax.slee.facilities.Level;

public abstract class SbbObjectConcurrencyTestSbb
extends BaseTCKSbb {
    private int sbbObjectID = -1;
    private Object sbbObjectIDLock = new Object();

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        this.createTraceSafe(Level.INFO, "Received TCKResourceEventX1");
        try {
            this.callTest(2);
        }
        catch (Exception ex) {
            TCKSbbUtils.handleException(ex);
        }
        throw new RuntimeException("Thrown to cause invocations of sbbExceptionThrown and sbbRolledBack");
    }

    public void onTCKResourceEventY1(TCKResourceEventY event, ActivityContextInterface aci) {
        this.createTraceSafe(Level.INFO, "Received TCKResourceEventY1");
        try {
            this.callTest(3);
        }
        catch (Exception ex) {
            TCKSbbUtils.handleException(ex);
        }
    }

    public void onTCKResourceEventY2(TCKResourceEventY event, ActivityContextInterface aci) {
        this.createTraceSafe(Level.INFO, "Received TCKResourceEventY2");
        try {
            this.callTest(4);
        }
        catch (Exception ex) {
            TCKSbbUtils.handleException(ex);
        }
    }

    public void onTCKResourceEventY3(TCKResourceEventY event, ActivityContextInterface aci) {
        this.createTraceSafe(Level.INFO, "Received TCKResourceEventY3");
        try {
            this.callTest(5);
        }
        catch (Exception ex) {
            TCKSbbUtils.handleException(ex);
        }
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
        TCKResourceEventX asXEvent;
        this.createTraceSafe(Level.INFO, "sbbExceptionThrown called");
        boolean expected = false;
        if (event instanceof TCKResourceEventX && "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1".equals((asXEvent = (TCKResourceEventX)event).getEventTypeName())) {
            expected = true;
            try {
                this.callTest(10);
            }
            catch (Exception e2) {
                TCKSbbUtils.handleException(e2);
            }
        }
        if (!expected) {
            TCKSbbUtils.handleException(new TCKTestErrorException("sbbExceptionThrown() called. event=" + event + ";aci=" + aci, exception));
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
        try {
            this.createTraceSafe(Level.INFO, "sbbRolledBack called");
            boolean handled = false;
            if (context.getEvent() instanceof TCKResourceEvent) {
                TCKResourceEvent asTCKResourceEvent = (TCKResourceEvent)context.getEvent();
                int callCode = -1;
                if ("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1".equals(asTCKResourceEvent.getEventTypeName())) {
                    callCode = 6;
                } else if ("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1".equals(asTCKResourceEvent.getEventTypeName())) {
                    callCode = 7;
                } else if ("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2".equals(asTCKResourceEvent.getEventTypeName())) {
                    callCode = 8;
                } else if ("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y3".equals(asTCKResourceEvent.getEventTypeName())) {
                    callCode = 9;
                }
                if (callCode != -1) {
                    handled = true;
                    this.callTest(callCode);
                }
            }
            if (!handled) {
                TCKSbbUtils.handleException(new TCKTestErrorException("Unexpected roll back. event=" + context.getEvent() + ";aci=" + context.getActivityContextInterface()));
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private Object callTest(int code) throws Exception {
        this.ensureSbbObjectID();
        int[] argument = new int[]{code, this.sbbObjectID};
        return TCKSbbUtils.getResourceInterface().callTest(argument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSbbObjectID() throws Exception {
        Object object = this.sbbObjectIDLock;
        synchronized (object) {
            if (this.sbbObjectID == -1) {
                int[] argument = new int[]{1, 0};
                Integer response = (Integer)TCKSbbUtils.getResourceInterface().callTest(argument);
                this.sbbObjectID = response;
            }
        }
    }
}

