/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.EventMessageData;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.EventReplyData;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.InitialEventSelectorParameters;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.slee.Address;

public class AbstractConvergenceNameTest
extends AbstractSleeTCKTest {
    public static final String SELECTED_VARIABLES = "selectedVariables";
    public static final String MAIN_ASSERTION_ID = "mainAssertionID";
    public static final String ACTIVITY_CONTEXT = "ActivityContext";
    public static final String ADDRESS_PROFILE = "AddressProfile";
    public static final String ADDRESS = "Address";
    public static final String EVENT_TYPE = "EventType";
    public static final String EVENT_OBJECT = "Event";
    public static final String CUSTOM_NAME = "CustomName";
    protected static final String ADDRESS_PREFIX = "1.0.0.";
    protected static final String ACTIVITY_ID_PREFIX = "Activity";
    private Object stateLock = new Object();
    private Vector selected;
    private int mainAssertionID;
    private String currentEventID;
    private String expectedConvergenceNameSbb;
    private boolean isEventDeliveryFinished;
    private Exception failureOrError;
    private final HashMap instancesToActivities = new HashMap();
    private final Vector expectedEventReceivers = new Vector();
    private final Vector eventReceivers = new Vector();
    private final Vector previousEvents = new Vector();
    private final Vector eventHistory = new Vector();

    public void setUp() throws Exception {
        super.setUp();
        this.setResourceListener(new TCKResourceListenerImpl());
        this.mainAssertionID = Integer.parseInt(this.utils().getTestParams().getProperty(MAIN_ASSERTION_ID));
        this.isEventDeliveryFinished = false;
        this.selected = this.elementsFromTokens(this.utils().getTestParams().getProperty(SELECTED_VARIABLES));
        if (this.selected != null) {
            Object[] validVariables = new String[]{ACTIVITY_CONTEXT, ADDRESS_PROFILE, ADDRESS, EVENT_TYPE, EVENT_OBJECT, CUSTOM_NAME};
            Arrays.sort(validVariables);
            Iterator selectedIter = this.selected.iterator();
            while (selectedIter.hasNext()) {
                String aVariable = (String)selectedIter.next();
                if (Arrays.binarySearch(validVariables, aVariable) >= 0) continue;
                throw new TCKTestErrorException("Invalid convergence name variable specified in the selectedVariables parameter: " + aVariable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEventAndWait(String eventTypeName, String eventID, TCKActivityID activityID, Address address, String expectedConvergenceNameSbb, InitialEventSelectorParameters iesParams) throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            if (eventTypeName == null) {
                throw new NullPointerException("eventTypeName may not be null");
            }
            if (eventID == null) {
                throw new NullPointerException("eventID may not be null");
            }
            if (activityID == null) {
                throw new NullPointerException("activityID may not be null");
            }
            this.currentEventID = eventID;
            this.expectedConvergenceNameSbb = expectedConvergenceNameSbb;
            if (this.previousEvents.contains(eventID)) {
                throw new TCKTestErrorException("Programmer error: eventID " + eventID + " has already been used");
            }
            if (eventID.equals(expectedConvergenceNameSbb)) {
                Vector<TCKActivityID> willAttachTo = new Vector<TCKActivityID>();
                willAttachTo.addElement(activityID);
                this.instancesToActivities.put(eventID, willAttachTo);
            } else if (expectedConvergenceNameSbb != null) {
                if (!this.instancesToActivities.containsKey(expectedConvergenceNameSbb)) {
                    throw new TCKTestErrorException("Programmer error: expectedConvergenceNameSbb parameter references an unknown SBB instance. Initial event of expectedConvergenceNameSbb=: " + expectedConvergenceNameSbb);
                }
                Vector attachedTo = (Vector)this.instancesToActivities.get(expectedConvergenceNameSbb);
                if (!attachedTo.contains(activityID)) {
                    attachedTo.addElement(activityID);
                }
            }
            Iterator instancesToActivitiesIter = this.instancesToActivities.keySet().iterator();
            while (instancesToActivitiesIter.hasNext()) {
                Object instance = instancesToActivitiesIter.next();
                Vector attachedTo = (Vector)this.instancesToActivities.get(instance);
                if (attachedTo == null) continue;
                Iterator attachedToIter = attachedTo.iterator();
                while (attachedToIter.hasNext()) {
                    Object attachedActivity = attachedToIter.next();
                    if (!((Object)activityID).equals(attachedActivity)) continue;
                    this.expectedEventReceivers.addElement(instance);
                }
            }
        }
        Object eventMessage = new EventMessageData(eventID, iesParams).toExported();
        this.utils().getResourceInterface().fireEvent(eventTypeName, eventMessage, activityID, address);
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.eventHistory.addElement("eventTypeName=" + eventTypeName + ", eventID=" + eventID + ", activityID=" + activityID + ",address=" + address + ", expectedConvergenceNameSbb=" + expectedConvergenceNameSbb + ",iesParams=[" + iesParams + "]");
            this.waitForResponse();
            this.expectedEventReceivers.clear();
            this.eventReceivers.clear();
            this.previousEvents.addElement(this.currentEventID);
            this.currentEventID = null;
            expectedConvergenceNameSbb = null;
            this.isEventDeliveryFinished = false;
        }
    }

    protected List selected() {
        return this.selected;
    }

    protected void setMainAssertionID(int mainAssertionID) {
        this.mainAssertionID = mainAssertionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResponse() throws Exception {
        long now = System.currentTimeMillis();
        long timeoutAt = now + (long)this.utils().getTestTimeout();
        Object object = this.stateLock;
        synchronized (object) {
            while (now < timeoutAt && !this.isEventDeliveryFinished && this.failureOrError == null) {
                try {
                    this.stateLock.wait(timeoutAt - now);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            if (this.failureOrError != null) {
                throw this.failureOrError;
            }
            if (!this.isEventDeliveryFinished) {
                throw new TCKTestErrorException("Timed out waiting waiting for an onEventProcessingSuccessful() or onEventProcessingFailed() callback for the event. Context info:" + this.getContextInfo());
            }
            if (!this.isEventDeliverySuccessful()) {
                this.diagnoseMissedDelivery();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEventDeliverySuccessful() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.expectedEventReceivers.size() == this.eventReceivers.size();
        }
    }

    private void diagnoseMissedDelivery() throws TCKTestFailureException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.expectedConvergenceNameSbb != null && !this.eventReceivers.contains(this.expectedConvergenceNameSbb)) {
                if (this.expectedConvergenceNameSbb.equals(this.currentEventID)) {
                    throw new TCKTestFailureException(this.mainAssertionID, "The expected new Sbb instance was not created for the event, which implies a failure in the convergence name algorithm. Context info:" + this.getContextInfo());
                }
                throw new TCKTestFailureException(this.mainAssertionID, "The existing Sbb instance which matched the convergence name of the event did not receive the event. This implies a failure in the convergence name algorithm. Context info:" + this.getContextInfo());
            }
            Vector missers = new Vector(this.expectedEventReceivers);
            missers.removeAll(this.eventReceivers);
            throw new TCKTestFailureException(769, "Existing Sbb(s) which were expected to be attached to activity did not receive the event. " + this.formatList(missers, "Sbb instances which missed the event", new StringBuffer()).toString() + ". Context info:" + this.getContextInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContextInfo() {
        StringBuffer rBuf = new StringBuffer("\n-- Context info: --\n");
        Object object = this.stateLock;
        synchronized (object) {
            this.formatList(this.selected(), "Selected convergence name variables", rBuf);
            this.formatList(this.eventHistory, "Event history list", rBuf);
            rBuf.append("currentEventID=" + this.currentEventID + "\n");
            if (this.expectedConvergenceNameSbb != null) {
                rBuf.append("expected initial event of convergence name SBB=" + this.expectedConvergenceNameSbb + "\n");
            } else {
                rBuf.append("no convergence name expected, or not an initial event\n");
            }
            this.formatList(this.eventReceivers, "Event receivers list", rBuf);
            this.formatList(this.expectedEventReceivers, "Expected event receivers list", rBuf);
            rBuf.append("Expected SBB instance and their activities:\n");
            Iterator instancesIter = this.instancesToActivities.keySet().iterator();
            while (instancesIter.hasNext()) {
                Object instanceID = instancesIter.next();
                rBuf.append("instanceID/initialEventID=" + instanceID + ';');
                rBuf.append("activityIDs={");
                Vector attachedTo = (Vector)this.instancesToActivities.get(instanceID);
                Iterator attachedToIter = attachedTo.iterator();
                while (attachedToIter.hasNext()) {
                    rBuf.append(attachedToIter.next() + ",");
                }
                rBuf.append("};\n");
            }
        }
        rBuf.append("(Context info ends)");
        return rBuf.toString();
    }

    private StringBuffer formatList(List list, String name, StringBuffer buf) {
        buf.append(name + ":\n");
        Iterator listIter = list.iterator();
        while (listIter.hasNext()) {
            buf.append(listIter.next()).append('\n');
        }
        return buf.append("(" + name + " ends)\n");
    }

    private Vector elementsFromTokens(String commaSeparatedList) {
        Vector<String> elements = null;
        if (commaSeparatedList != null) {
            StringTokenizer tokens = new StringTokenizer(commaSeparatedList, ",");
            elements = new Vector<String>();
            while (tokens.hasMoreTokens()) {
                elements.addElement(tokens.nextToken());
            }
        }
        return elements;
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object onSbbCall(Object argument) throws Exception {
            try {
                EventReplyData replyData = EventReplyData.fromExported(argument);
                String receivedEventID = replyData.getReceivedEventID();
                String initialEventID = replyData.getInitialEventID();
                AbstractConvergenceNameTest.this.getLog().info("Received message from SBB. receivedEventID=" + receivedEventID + ",initialEventID=" + initialEventID);
                if (receivedEventID == null) {
                    throw new TCKTestErrorException("Received response containing a null receivedEventID. Context info:" + AbstractConvergenceNameTest.this.getContextInfo());
                }
                if (initialEventID == null) {
                    throw new TCKTestErrorException("Received response containing a null initialEventID. Context info:" + AbstractConvergenceNameTest.this.getContextInfo());
                }
                Object object = AbstractConvergenceNameTest.this.stateLock;
                synchronized (object) {
                    if (!receivedEventID.equals(AbstractConvergenceNameTest.this.currentEventID)) {
                        if (receivedEventID.equals(initialEventID)) {
                            throw new TCKTestFailureException(AbstractConvergenceNameTest.this.mainAssertionID, "Received event " + receivedEventID + " on a new Sbb instance after it was delivered to all expected receivers, " + "which implies a failure in the convergence name algorithm. Context info: " + AbstractConvergenceNameTest.this.getContextInfo());
                        }
                        throw new TCKTestFailureException(AbstractConvergenceNameTest.this.mainAssertionID, "Received event " + receivedEventID + " after it was delivered to all expected receivers. Illegal receiver's initial event=" + initialEventID + ". This Sbb instance was not the expected convergence name target, and was not " + "expected to be previously attached to the activity: this implies a failure in the " + "convergence name algorithm. Context info:" + AbstractConvergenceNameTest.this.getContextInfo());
                    }
                    if (AbstractConvergenceNameTest.this.eventReceivers.contains(initialEventID)) {
                        throw new TCKTestFailureException(1984, "Event " + receivedEventID + " was received twice by SBB instance with initial event " + initialEventID + ". Context info:" + AbstractConvergenceNameTest.this.getContextInfo());
                    }
                    AbstractConvergenceNameTest.this.eventReceivers.addElement(initialEventID);
                    if (!AbstractConvergenceNameTest.this.expectedEventReceivers.contains(initialEventID)) {
                        if (initialEventID.equals(receivedEventID)) {
                            throw new TCKTestFailureException(AbstractConvergenceNameTest.this.mainAssertionID, "The SLEE created an SBB instance when not expected to: this implies a failure in the convergence name algorithm. Context info:" + AbstractConvergenceNameTest.this.getContextInfo());
                        }
                        throw new TCKTestFailureException(AbstractConvergenceNameTest.this.mainAssertionID, "The SLEE delivered the event to an SBB instance not attached to the activity, with a different convergence name from the event. this implies a failure in the convergence name algorithm. Context info: " + AbstractConvergenceNameTest.this.getContextInfo());
                    }
                    if (initialEventID.equals(AbstractConvergenceNameTest.this.expectedConvergenceNameSbb)) {
                        if (initialEventID.equals(receivedEventID)) {
                            AbstractConvergenceNameTest.this.getLog().fine("The SLEE created a new SBB instance for the event");
                        } else {
                            AbstractConvergenceNameTest.this.getLog().fine("The SLEE delivered the event to an existing SBB instance with a matching convergence name");
                        }
                    } else {
                        AbstractConvergenceNameTest.this.getLog().fine("The SLEE delivered the event to an SBB instance which was attached to the event's activity");
                    }
                    if (AbstractConvergenceNameTest.this.expectedEventReceivers.size() == AbstractConvergenceNameTest.this.eventReceivers.size()) {
                        AbstractConvergenceNameTest.this.stateLock.notifyAll();
                    }
                }
            }
            catch (Exception e) {
                Object object = AbstractConvergenceNameTest.this.stateLock;
                synchronized (object) {
                    AbstractConvergenceNameTest.this.failureOrError = e;
                    AbstractConvergenceNameTest.this.stateLock.notifyAll();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEventProcessingSuccessful(long eventObjectID) throws RemoteException {
            Object object = AbstractConvergenceNameTest.this.stateLock;
            synchronized (object) {
                AbstractConvergenceNameTest.this.isEventDeliveryFinished = true;
                AbstractConvergenceNameTest.this.stateLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEventProcessingFailed(long eventObjectID, String message, Exception exception) throws RemoteException {
            Object object = AbstractConvergenceNameTest.this.stateLock;
            synchronized (object) {
                AbstractConvergenceNameTest.this.isEventDeliveryFinished = true;
                StringBuffer buf = new StringBuffer("Received onEventProcessingFailed() callback for TCKResourceEvent with object ID=" + eventObjectID);
                if (message != null) {
                    buf.append(message);
                }
                this.onException(new TCKTestErrorException(buf.toString(), exception));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(Exception exception) throws RemoteException {
            AbstractConvergenceNameTest.this.getLog().warning("Received Exception from SBB or resource:");
            AbstractConvergenceNameTest.this.getLog().warning(exception);
            Object object = AbstractConvergenceNameTest.this.stateLock;
            synchronized (object) {
                AbstractConvergenceNameTest.this.failureOrError = exception;
                AbstractConvergenceNameTest.this.stateLock.notifyAll();
            }
        }
    }
}

