/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.AbstractMultiVariableSelectionTest;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.InitialEventSelectorParameters;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AddressProfileProxyImpl;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class MultiVariableSelectionTest
extends AbstractMultiVariableSelectionTest {
    private static final String PAUSE_BETWEEN_SENDS_MS_PARAM = "pauseBetweenSendsMs";
    private static final String PROFILE_1 = "PROFILE_1";
    private static final String PROFILE_2 = "PROFILE_2";
    private static final String ADDRESS_PROFILE_TABLE = "tck.AddressAndProfileTestProfile";
    private static final Address ADDRESS_1 = new Address(AddressPlan.IP, "1.0.0.1");
    private static final Address ADDRESS_2 = new Address(AddressPlan.IP, "1.0.0.2");
    private static final Address ADDRESS_3 = new Address(AddressPlan.IP, "1.0.0.3");
    private static final Address ADDRESS_4 = new Address(AddressPlan.IP, "1.0.0.4");
    private static final Address[] ADDRESS_SET_A = new Address[]{ADDRESS_1, ADDRESS_2};
    private static final Address[] ADDRESS_SET_B = new Address[]{ADDRESS_3, ADDRESS_4};
    private ProfileUtils profileUtils;
    private int pauseBetweenSendsMs;
    private int currentActivityIDSuffix = 0;
    private int currentEventID = 0;
    private ProfileProvisioningMBeanProxy profileProxy;
    private Vector activityIDs;

    public TCKTestResult run() throws Exception {
        for (int i = 0; i < this.getCombinations().size(); ++i) {
            Vector selectedVariables = (Vector)this.getCombinations().elementAt(i);
            this.performVariableNonSelectionTest(selectedVariables);
        }
        return TCKTestResult.passed();
    }

    private void performVariableNonSelectionTest(Vector selectedVariables) throws Exception {
        this.getLog().info("Performing constant non selection test for selected variables: " + selectedVariables);
        InitialEventSelectorParameters iesParams = !selectedVariables.contains("CustomName") ? this.createIESParamsFromSelected(selectedVariables, null) : this.createIESParamsFromSelected(selectedVariables, "custom_name_A");
        String initialEvent = String.valueOf(this.currentEventID++);
        TCKActivityID mainActivityID = this.createNextActivity();
        this.getLog().info("Created activity: " + mainActivityID.getName());
        TCKActivityID activityID = mainActivityID;
        Address address = ADDRESS_1;
        this.replaceAddressProfile(PROFILE_2, new Address[0]);
        this.replaceAddressProfile(PROFILE_1, ADDRESS_SET_A);
        this.replaceAddressProfile(PROFILE_2, ADDRESS_SET_B);
        String eventType = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1";
        this.sendEventAndWait(eventType, initialEvent, mainActivityID, ADDRESS_1, initialEvent, iesParams);
        this.pauseBetweenSends();
        this.sendEventAndWait(eventType, String.valueOf(this.currentEventID++), mainActivityID, ADDRESS_1, initialEvent, iesParams);
        this.pauseBetweenSends();
        for (int i = 0; i < VARIABLES.length; ++i) {
            String variable = VARIABLES[i];
            if (selectedVariables.contains(variable) || variable.equals("CustomName")) continue;
            this.getLog().info("Varying variable " + variable);
            if (variable.equals("Address")) {
                address = ADDRESS_2;
            } else if (variable.equals("AddressProfile")) {
                this.replaceAddressProfile(PROFILE_2, new Address[0]);
                this.replaceAddressProfile(PROFILE_1, ADDRESS_SET_B);
                this.replaceAddressProfile(PROFILE_2, ADDRESS_SET_A);
            } else if (variable.equals("ActivityContext")) {
                activityID = this.createNextActivity();
            } else if (variable.equals("EventType")) {
                eventType = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2";
            } else if (variable.equals("Event")) {
                // empty if block
            }
            this.sendEventAndWait(eventType, String.valueOf(this.currentEventID++), activityID, address, initialEvent, iesParams);
            this.pauseBetweenSends();
        }
    }

    public void setUp() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProxy = this.profileUtils.getProfileProvisioningProxy();
        this.profileUtils.createStandardAddressProfileTable(ADDRESS_PROFILE_TABLE);
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_1, ADDRESS_SET_A);
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_2, ADDRESS_SET_B);
        this.pauseBetweenSendsMs = Integer.parseInt(this.utils().getTestParams().getProperty(PAUSE_BETWEEN_SENDS_MS_PARAM));
        if (this.pauseBetweenSendsMs < 0) {
            throw new TCKTestErrorException("Invalid value for 'pauseBetweenSendsMs' parameter (can't be negative): " + this.pauseBetweenSendsMs);
        }
        this.activityIDs = new Vector();
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        Vector vector = this.activityIDs;
        synchronized (vector) {
            Iterator iter = this.activityIDs.iterator();
            while (iter.hasNext()) {
                resource.endActivity((TCKActivityID)iter.next());
                iter.remove();
                this.pauseBetweenSends();
            }
        }
        super.tearDown();
        if (this.profileUtils != null) {
            this.profileProxy.removeProfile(ADDRESS_PROFILE_TABLE, PROFILE_1);
            this.profileProxy.removeProfile(ADDRESS_PROFILE_TABLE, PROFILE_2);
            this.profileProxy.removeProfileTable(ADDRESS_PROFILE_TABLE);
        }
    }

    private void setupAddressProfile(String tableName, String profileName, Address[] addresses) throws Exception {
        ObjectName objectName = this.profileProxy.createProfile(tableName, profileName);
        this.setAddressProfile(objectName, addresses);
    }

    private void replaceAddressProfile(String profileName, Address[] addresses) throws Exception {
        ObjectName objectName = this.profileProxy.getProfile(ADDRESS_PROFILE_TABLE, profileName);
        this.setAddressProfile(objectName, addresses);
    }

    private void setAddressProfile(ObjectName objectName, Address[] addresses) throws Exception {
        AddressProfileProxyImpl addressProfileProxy = new AddressProfileProxyImpl(objectName, this.utils().getMBeanFacade());
        addressProfileProxy.editProfile();
        addressProfileProxy.setAddresses(addresses);
        addressProfileProxy.commitProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKActivityID createNextActivity() throws TCKTestErrorException, RemoteException {
        Vector vector = this.activityIDs;
        synchronized (vector) {
            TCKActivityID activityID = this.utils().getResourceInterface().createActivity("Activity" + this.currentActivityIDSuffix++);
            this.activityIDs.addElement(activityID);
            return activityID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseBetweenSends() throws InterruptedException {
        if (this.pauseBetweenSendsMs > 0) {
            this.getLog().finest("Waiting for " + this.pauseBetweenSendsMs + " milliseconds");
            MultiVariableSelectionTest multiVariableSelectionTest = this;
            synchronized (multiVariableSelectionTest) {
                this.wait(this.pauseBetweenSendsMs);
            }
        }
    }
}

