/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class Test1108195Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    public static final String activityNameA = "Test1108195Test-ActivityA";
    public static final String activityNameB = "Test1108195Test-ActivityB";
    private static final int defaultTimeout = 25000;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private int receivedCountSbb1 = 0;
    private int receivedCountSbb2 = 0;
    private int receivedCustomEventSbb1 = 0;
    private int expectedCountSbb1;
    private int expectedCountSbb2;
    private static final String testName = "Test1108195";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityA = resource.createActivity(activityNameA);
        TCKActivityID activityB = resource.createActivity(activityNameB);
        this.getLog().fine("Firing TCKResourceEventX1 on Test1108195Test-ActivityA.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", testName, activityA, null);
        this.expectedCountSbb1 = 1;
        this.expectedCountSbb2 = 0;
        Test1108195Test test1108195Test = this;
        synchronized (test1108195Test) {
            this.wait(1000L);
        }
        if (this.expectedCountSbb1 != this.receivedCountSbb1 || this.receivedCountSbb2 != this.expectedCountSbb2) {
            result.setFailed(1108195, "First check: Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + (this.expectedCountSbb1 + this.expectedCountSbb2) + ", received " + (this.receivedCountSbb1 + this.receivedCountSbb2) + ")");
            return;
        }
        this.getLog().fine("Firing TCKResourceEventX2 on Test1108195Test-ActivityA.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", testName, activityA, null);
        test1108195Test = this;
        synchronized (test1108195Test) {
            this.wait(1000L);
        }
        if (this.expectedCountSbb1 != this.receivedCountSbb1 || this.receivedCountSbb2 != this.expectedCountSbb2 || this.receivedCustomEventSbb1 != 0) {
            result.setFailed(1108191, "Second check: Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + (this.expectedCountSbb1 + this.expectedCountSbb2) + ", received " + (this.receivedCountSbb1 + this.receivedCountSbb2) + ")");
            return;
        }
        this.getLog().fine("Firing TCKResourceEventX3 on Test1108195Test-ActivityA and Test1108195Test-ActivityB.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3", testName, activityA, null);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3", testName, activityB, null);
        this.getLog().fine("Waiting for test pass indicator from SBB.");
        this.expectedCountSbb2 = 4;
        this.expectedCountSbb1 = 4;
        test1108195Test = this;
        synchronized (test1108195Test) {
            this.wait(23000L);
        }
        if (this.receivedCustomEventSbb1 <= this.receivedCountSbb1) {
            result.setFailed(1108192, "Third check: Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + (this.expectedCountSbb1 + this.expectedCountSbb2) + ", received " + (this.receivedCountSbb1 + this.receivedCountSbb2) + ")");
            return;
        }
        if (this.expectedCountSbb1 == this.receivedCountSbb1 && this.receivedCountSbb2 == this.expectedCountSbb2) {
            result.setPassed();
        } else {
            result.setFailed(1108195, "Fourth check: Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + (this.expectedCountSbb1 + this.expectedCountSbb2) + ", received " + (this.receivedCountSbb1 + this.receivedCountSbb2) + ")");
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1108195Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108195Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                if (sbbTestMessage.contains("Sbb1")) {
                    if (sbbTestMessage.contains("TCKResourceEventX1") && Test1108195Test.this.receivedCountSbb1 == 0 || sbbTestMessage.contains("TCKResourceEventX3 on ActivityB") && Test1108195Test.this.receivedCountSbb1 == 1 || sbbTestMessage.contains("TCKResourceEventX2") && Test1108195Test.this.receivedCountSbb1 == 2 || sbbTestMessage.contains("TCKResourceEventX3 on ActivityA") && Test1108195Test.this.receivedCountSbb1 == 3) {
                        Test1108195Test.this.receivedCountSbb1++;
                    } else if (sbbTestMessage.contains("Test1108195Event") && Test1108195Test.this.receivedCountSbb1 == 2) {
                        Test1108195Test.this.receivedCustomEventSbb1 = 5;
                    }
                } else if (sbbTestMessage.contains("Sbb2") && (sbbTestMessage.contains("TCKResourceEventX3 on ActivityB") && Test1108195Test.this.receivedCountSbb2 <= 1 || sbbTestMessage.contains("TCKResourceEventX1") && Test1108195Test.this.receivedCountSbb2 <= 1 || sbbTestMessage.contains("TCKResourceEventX2") && Test1108195Test.this.receivedCountSbb2 == 2 || sbbTestMessage.contains("TCKResourceEventX3 on ActivityA") && Test1108195Test.this.receivedCountSbb2 == 3)) {
                    Test1108195Test.this.receivedCountSbb2++;
                }
            }
            catch (TCKTestFailureException ex) {
                Test1108195Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108195Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108195Test.this.getLog().warning(exception);
            Test1108195Test.this.result.setError(exception);
        }
    }
}

