/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.maskcumulative;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventY;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.CreateException;
import javax.slee.NotAttachedException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.Level;

public abstract class AssertionSbb
extends BaseTCKSbb {
    public void sbbCreate() throws CreateException {
        this.setReceivedX1(false);
        this.setReceivedX2(false);
        this.setReceivedY1(false);
        this.setReceivedY2(false);
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            String[] eventMask = new String[]{"TCKResourceEventX2"};
            this.getSbbContext().maskEvent(eventMask, aci);
            eventMask[0] = "TCKResourceEventY1";
            this.getSbbContext().maskEvent(eventMask, aci);
        }
        catch (UnrecognizedEventException uee) {
            throw new RuntimeException(uee.getMessage());
        }
        catch (NotAttachedException nae) {
            throw new RuntimeException(nae.getMessage());
        }
        this.setReceivedX1(true);
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci) {
        this.setReceivedX2(true);
    }

    public void onTCKResourceEventY1(TCKResourceEventY event, ActivityContextInterface aci) {
        this.setReceivedY1(true);
    }

    public void onTCKResourceEventY2(TCKResourceEventY event, ActivityContextInterface aci) {
        this.setReceivedY2(true);
        if (this.getReceivedX1() && this.getReceivedX2() && !this.getReceivedY1() && this.getReceivedY2()) {
            this.sendTestSuccess();
        } else {
            this.sendTestFail("received events should be true, true, false, true instead got: " + this.getReceivedX1() + ", " + this.getReceivedX2() + ", " + this.getReceivedY1() + ", " + this.getReceivedY2());
        }
    }

    private void sendTestSuccess() {
        this.sendMessage("SUCCESS", "");
    }

    private void sendTestFail(String reason) {
        this.sendMessage("FAILURE", reason);
    }

    private void sendMessage(String arg1, String arg2) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.FINE, "sending a message back with values: " + arg1 + ", and " + arg2, null);
            String[] message = new String[]{arg1, arg2};
            TCKSbbUtils.getResourceInterface().sendSbbMessage(message);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public abstract boolean getReceivedX1();

    public abstract void setReceivedX1(boolean var1);

    public abstract boolean getReceivedX2();

    public abstract void setReceivedX2(boolean var1);

    public abstract boolean getReceivedY1();

    public abstract void setReceivedY1(boolean var1);

    public abstract boolean getReceivedY2();

    public abstract void setReceivedY2(boolean var1);
}

