/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.servicestarted;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;

public class Test1108102Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID1;
    private DeployableUnitID duID2;
    private boolean recieveServiceAFlag = false;
    private boolean recieveServiceBFlag = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceProxy = this.utils().getServiceManagementMBeanProxy();
        DeployableUnitDescriptor duDesc1 = duProxy.getDescriptor(this.duID1);
        ComponentID[] components1 = duDesc1.getComponents();
        ServiceID firstService = null;
        ServiceID secondService = null;
        for (int i = 0; i < components1.length; ++i) {
            if (!(components1[i] instanceof ServiceID)) continue;
            ServiceID service = (ServiceID)components1[i];
            if (firstService != null) continue;
            firstService = service;
        }
        if (firstService == null) {
            result.setError("Failed to the first test services.");
            return;
        }
        this.getLog().fine("Activating the first service");
        serviceProxy.activate(firstService);
        Test1108102Test i = this;
        synchronized (i) {
            this.wait(3000L);
        }
        if (!this.recieveServiceAFlag) {
            result.setFailed(1108102, "Test harness didn't receive a ServiceActivated event for the first service.");
            return;
        }
        if (!ServiceState.ACTIVE.equals((Object)serviceProxy.getState(firstService))) {
            result.setError("First service " + firstService + " failed to activate.");
            return;
        }
        this.getLog().fine("The service " + firstService + " is in Active state");
        DeployableUnitDescriptor duDesc2 = duProxy.getDescriptor(this.duID2);
        ComponentID[] components2 = duDesc2.getComponents();
        for (int i2 = 0; i2 < components2.length; ++i2) {
            if (!(components2[i2] instanceof ServiceID)) continue;
            ServiceID service = (ServiceID)components2[i2];
            if (secondService != null) continue;
            secondService = service;
            break;
        }
        if (secondService == null) {
            result.setError("Failed to the second test services.");
            return;
        }
        if (!ServiceState.INACTIVE.equals((Object)serviceProxy.getState(secondService))) {
            result.setError("Second service " + secondService + " should be inactive but was not.");
            return;
        }
        this.getLog().fine("Activating the second service");
        serviceProxy.activate(secondService);
        this.recieveServiceAFlag = false;
        Test1108102Test test1108102Test = this;
        synchronized (test1108102Test) {
            this.wait(3000L);
        }
        if (!this.recieveServiceAFlag && this.recieveServiceBFlag) {
            result.setPassed();
        } else {
            result.setFailed(1108102, "Test harness didn't receive a ServiceActivated event for the second service.");
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing service");
        String duPath1 = this.utils().getTestParams().getProperty(SERVICE1_DU_PATH_PARAM);
        String duPath2 = this.utils().getTestParams().getProperty(SERVICE2_DU_PATH_PARAM);
        this.duID1 = this.utils().install(duPath1);
        this.duID2 = this.utils().install(duPath2);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1108102Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108102Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                if (sbbTestMessage.contains("name=Test1108102Service1")) {
                    Test1108102Test.this.recieveServiceAFlag = true;
                }
                if (sbbTestMessage.contains("name=Test1108102Service2")) {
                    Test1108102Test.this.recieveServiceBFlag = true;
                }
            }
            catch (TCKTestFailureException ex) {
                Test1108102Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108102Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108102Test.this.getLog().warning(exception);
            Test1108102Test.this.result.setError(exception);
        }
    }
}

