/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.servicestarted;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.testsuite.events.servicestarted.QueuingSleeStateListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;
import javax.slee.management.SleeState;
import javax.slee.management.SleeStateChangeNotification;

public class Test1108169Test
extends AbstractSleeTCKTest {
    public static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private FutureResult result;
    private SleeManagementMBeanProxy management;
    private static final int expectedCount = 2;
    private int receivedCount = 0;
    private QueuingSleeStateListener stateListener;
    private RMIObjectChannel in;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        try {
            this.management.start();
        }
        catch (Exception e) {
            result.setError("Failed to start a previosly stopped SLEE into the Running state");
            return;
        }
        if (!this.management.getState().isRunning()) {
            this.getLog().warning("Current state: " + this.management.getState());
            result.setError("ERROR! Current state: " + this.management.getState());
            return;
        }
        this.getLog().info("Current state: " + this.management.getState());
        Test1108169Test e = this;
        synchronized (e) {
            this.wait(5000L);
        }
        Object[] messages = this.in.readQueue(10000L);
        for (int i = 0; i < messages.length; ++i) {
            Map sbbData = (Map)messages[i];
            String sbbTestName = (String)sbbData.get("testName");
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            ++this.receivedCount;
        }
        if (this.receivedCount == 2) {
            result.setPassed();
        } else {
            result.setFailed(1108169, "Expected number of successful messages not received, messages werenot delivered by the SBBs (expected 2, received " + this.receivedCount + ")");
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to RMIObjectChannel");
        this.in = this.utils().getRMIObjectChannel();
        this.stateListener = new QueuingSleeStateListener(this.utils());
        this.management = this.utils().getSleeManagementMBeanProxy();
        this.management.addNotificationListener(this.stateListener, null, null);
        this.getLog().fine("Installing a service");
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        DeployableUnitID duID = this.utils().install(duPath);
        this.utils().activateServices(duID, true);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceProxy = this.utils().getServiceManagementMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(duID);
        ComponentID[] components = duDesc.getComponents();
        ServiceID firstService = null;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            ServiceID service = (ServiceID)components[i];
            if (firstService != null) continue;
            firstService = service;
            break;
        }
        if (firstService == null) {
            this.result.setError("Failed to find the test service.");
            return;
        }
        ServiceState serviceState = serviceProxy.getState(firstService);
        if (!serviceState.isActive()) {
            this.getLog().warning("Current service state: " + serviceState);
            this.result.setError("ERROR! Current service state: " + serviceState);
            return;
        }
        this.getLog().info("Current service state: " + serviceState);
        this.management = this.utils().getSleeManagementMBeanProxy();
        this.getLog().info("Calling SleeManagementMBean.getState()");
        try {
            this.management.stop();
            this.waitForStateChange(SleeState.STOPPED);
        }
        catch (Exception e) {
            this.onException(e);
            return;
        }
        SleeState currentState = this.management.getState();
        if (currentState == null) {
            this.getLog().severe("Current state: " + currentState);
            this.result.setError("ERROR! returned " + currentState + " value for the current state");
            return;
        }
        if (!currentState.isStopped()) {
            this.getLog().warning("Current state: " + currentState);
            this.result.setError("ERROR! Current state: " + currentState);
            return;
        }
        this.getLog().info("Current state: " + currentState);
    }

    private void waitForStateChange(SleeState expectedState) throws Exception {
        SleeStateChangeNotification stateChange = null;
        try {
            while (stateChange == null || !stateChange.getNewState().equals((Object)expectedState)) {
                this.getLog().fine("Waiting to move to the " + expectedState + " state.");
                stateChange = this.stateListener.nextNotification();
                this.getLog().fine("SLEE has moved to the " + stateChange + " state.");
            }
        }
        catch (OperationTimedOutException e) {
            this.onException(e);
        }
    }

    public void onException(Exception e) throws RemoteException {
        this.getLog().warning("Received exception from SBB.");
        this.getLog().warning(e);
        this.result.setError(e);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }
}

