/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;

public class Test1113436Test
extends AbstractSleeTCKTest {
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private DeployableUnitID duID;
    private AlarmMBeanProxy alarmMBeanProxy;
    private FutureResult result;
    private SbbID sbbID;
    private ServiceID serviceID;
    private String[] alarmIDs;
    private String testName = "Test1113436";

    public void run(FutureResult result) throws Exception {
        this.result = result;
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        SbbNotification sbbNotification = new SbbNotification(this.serviceID, this.sbbID);
        try {
            this.getLog().fine("Starting to get all existing unique alarm identifiers for stateful alarms currently active in the SLEE that were raised by the specified notification source.");
            this.alarmIDs = this.alarmMBeanProxy.getAlarms((NotificationSource)sbbNotification);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            result.setError("ERROR!", e);
        }
        String activityName = "Test1113436Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        this.alarmMBeanProxy = this.utils().getAlarmMBeanProxy();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                String newAlarmID = alarmNotification.getAlarmID();
                for (int i = 0; i < Test1113436Test.this.alarmIDs.length; ++i) {
                    if (!Test1113436Test.this.alarmIDs[i].equals(newAlarmID)) continue;
                    Test1113436Test.this.result.setFailed(1113436, "The identified alarm has arelady been raised!");
                    return;
                }
                if (alarmNotification.getMessage().equals("Test1113436AlarmMessage")) {
                    Test1113436Test.this.result.setPassed();
                } else {
                    Test1113436Test.this.result.setFailed(1113436, "Message in AlarmNotification was not that set in AlarmFacility.raiseAlarm()");
                }
                return;
            }
            Test1113436Test.this.getLog().info("Notification received: " + notification);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1113436Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1113436Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1113436Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1113436Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1113436Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1113436Test.this.getLog().warning(exception);
            Test1113436Test.this.result.setError(exception);
        }
    }
}

