/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitID;

public class Test1113437Test
extends AbstractSleeTCKTest {
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private DeployableUnitID duID;
    private AlarmMBeanProxy alarmMBeanProxy;
    private FutureResult result;
    private String testName = "Test1113437";
    private boolean passed = false;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        String activityName = "Test1113437Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        this.alarmMBeanProxy = this.utils().getAlarmMBeanProxy();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                Test1113437Test.this.getLog().debug(alarmNotification.toString());
                if (alarmNotification.getMessage().equals("Test1113437AlarmMessage") && alarmNotification.getAlarmLevel() == AlarmLevel.MAJOR) {
                    Test1113437Test.this.getLog().info("Received the raised alarm.");
                    Test1113437Test.this.passed = true;
                } else if (alarmNotification.getMessage().equals("Test1113437AlarmMessage") && alarmNotification.getAlarmLevel() == AlarmLevel.CLEAR && Test1113437Test.this.passed) {
                    Test1113437Test.this.getLog().info("Received the raised alarm been cleared");
                    Test1113437Test.this.result.setPassed();
                } else {
                    Test1113437Test.this.result.setFailed(1113437, "Message in AlarmNotification was not that set in AlarmFacility.raiseAlarm()");
                }
                return;
            }
            Test1113437Test.this.getLog().info("Notification received: " + notification);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1113437Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1113437Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1113437Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1113437Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1113437Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1113437Test.this.getLog().warning(exception);
            Test1113437Test.this.result.setError(exception);
        }
    }
}

