/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.Tracer;

public abstract class Test1113507Sbb
extends BaseTCKSbb {
    public static final String ALARM_MESSAGE_CRITICAL = "CRITICAL:Test1113484AlarmMessage";
    public static final String ALARM_MESSAGE_MAJOR = "MAJOR:Test1113484AlarmMessage";
    public static final String ALARM_MESSAGE_WARNING = "WARNING:Test1113484AlarmMessage";
    public static final String ALARM_MESSAGE_INDETERMINATE = "INDETERMINATE:Test1113484AlarmMessage";
    public static final String ALARM_MESSAGE_MINOR = "MINOR:Test1113484AlarmMessage";
    public static final String ALARM_INSTANCEID = "Test1113507AlarmInstanceID";
    public static final String ALARM_TYPE = "javax.slee.management.Alarm";
    public static final AlarmLevel ALARM_LEVEL = AlarmLevel.MAJOR;
    private Tracer tracer;

    public void onTCKResourceEventX1(TCKResourceEventX ev, ActivityContextInterface aci) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Received " + ev + " message", null);
            this.doTest1113507Test();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void doTest1113507Test() throws Exception {
        AlarmFacility facility = this.getAlarmFacility();
        try {
            String alarmID1 = facility.raiseAlarm(ALARM_TYPE, "Test1113507AlarmInstanceID1", AlarmLevel.CRITICAL, ALARM_MESSAGE_CRITICAL);
            this.tracer.info("Raising an alarm " + alarmID1);
            String alarmID2 = facility.raiseAlarm(ALARM_TYPE, "Test1113507AlarmInstanceID2", AlarmLevel.MAJOR, ALARM_MESSAGE_MAJOR);
            this.tracer.info("Raising an alarm " + alarmID2);
            String alarmID3 = facility.raiseAlarm(ALARM_TYPE, "Test1113507AlarmInstanceID3", AlarmLevel.WARNING, ALARM_MESSAGE_WARNING);
            this.tracer.info("Raising an alarm " + alarmID3);
            String alarmID4 = facility.raiseAlarm(ALARM_TYPE, "Test1113507AlarmInstanceID4", AlarmLevel.INDETERMINATE, ALARM_MESSAGE_INDETERMINATE);
            this.tracer.info("Raising an alarm " + alarmID4);
            String alarmID5 = facility.raiseAlarm(ALARM_TYPE, "Test1113507AlarmInstanceID5", AlarmLevel.MINOR, ALARM_MESSAGE_MINOR);
            this.tracer.info("Raising an alarm " + alarmID5);
            String[] alarmIDs = new String[]{alarmID1, alarmID2, alarmID3, alarmID4, alarmID5};
            this.setFirstAlarm(alarmIDs);
            if (facility.clearAlarms(ALARM_TYPE) != alarmIDs.length) {
                this.sendResultToTCK("Test1113507Test", false, 1113509, "The return value of this facility.clearAlarms(alarmType) method didn't match the number of alarms that supposed to be cleared!AlarmFacility.clearAlarms(Alarm_type)= " + facility.clearAlarms(ALARM_TYPE) + "vs Total alarms= " + alarmIDs.length);
                return;
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
        boolean passed = false;
        try {
            facility.clearAlarms(null);
        }
        catch (NullPointerException e) {
            this.tracer.info("got expected NullPointerException when ALARM_TYPE is null", null);
            passed = true;
        }
        if (!passed) {
            this.sendResultToTCK("Test1113507Test", false, 1113510, "AlarmFacility.clearAlarms(null) should have thrown java.lang.NullPointerException.");
            return;
        }
    }

    private void sendResultToTCK(String testName, boolean result, int failedAssertionID, String message) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private AlarmFacility getAlarmFacility() throws Exception {
        AlarmFacility facility = null;
        String JNDI_ALARMFACILITY_NAME = "java:comp/env/slee/facilities/alarm";
        try {
            facility = (AlarmFacility)new InitialContext().lookup(JNDI_ALARMFACILITY_NAME);
        }
        catch (Exception e) {
            this.tracer.warning("got unexpected Exception: " + e, null);
        }
        return facility;
    }

    public abstract void setFirstAlarm(String[] var1);

    public abstract String[] getFirstAlarm();
}

