/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.AlarmNotification;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;

public class Test1113512Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    private NotificationListener listener;
    private AlarmMBeanProxy alarmMBeanProxy;
    private FutureResult result;
    private String testName = "Test1113512";
    private int receivedAlarmNotifications = 0;
    private int receivedRaisedAlarmNotifications = 0;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        String activityName = "Test1113512Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
        this.alarmMBeanProxy = this.utils().getAlarmMBeanProxy();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                SbbNotification sbbNotification = (SbbNotification)alarmNotification.getNotificationSource();
                int inActiveAlarms = 0;
                int activeAlarms = 0;
                if (alarmNotification.getMessage().equals("Sbb1:Test1113512AlarmMessage")) {
                    try {
                        inActiveAlarms = Test1113512Test.this.alarmMBeanProxy.getAlarms((NotificationSource)sbbNotification).length;
                        if (inActiveAlarms >= 1) {
                            Test1113512Test.this.result.setFailed(1113512, "Request that all alarms belonging to the notification source associated with the AlarmFacility object be cleared. So there should be no alarms need to be cleared, but the result returned " + inActiveAlarms + " currently active in the slee.");
                            return;
                        }
                        if (alarmNotification.getAlarmLevel().equals((Object)AlarmLevel.CLEAR)) {
                            Test1113512Test.this.receivedAlarmNotifications++;
                        }
                    }
                    catch (Exception e) {
                        Test1113512Test.this.getLog().warning("Received Exception from SBB or resource:");
                        Test1113512Test.this.getLog().warning(e);
                        Test1113512Test.this.result.setError(e);
                    }
                } else if (alarmNotification.getMessage().equals("Sbb2:Test1113512AlarmMessage")) {
                    try {
                        Test1113512Test.this.receivedRaisedAlarmNotifications++;
                        activeAlarms = Test1113512Test.this.alarmMBeanProxy.getAlarms((NotificationSource)sbbNotification).length;
                        if (activeAlarms != 5 && Test1113512Test.this.receivedRaisedAlarmNotifications == 5) {
                            Test1113512Test.this.result.setFailed(1113588, "There should be five active alarms raised by sbb2/service2 in the SLEE, but the result returned " + activeAlarms + " currently " + "active in the slee.");
                        }
                        if (alarmNotification.getAlarmLevel().equals((Object)AlarmLevel.CLEAR)) {
                            Test1113512Test.this.receivedAlarmNotifications++;
                        }
                        if (Test1113512Test.this.receivedRaisedAlarmNotifications == 5) {
                            if (inActiveAlarms == 0 && activeAlarms == 5 && Test1113512Test.this.receivedAlarmNotifications == 5) {
                                Test1113512Test.this.result.setPassed();
                            } else {
                                Test1113512Test.this.result.setFailed(1113512, "There should be no active alarms in Sbb1, but it returned " + inActiveAlarms + "and there should be five active alarms in Sbb2, but it returned " + activeAlarms + ":" + Test1113512Test.this.receivedAlarmNotifications);
                            }
                        }
                        return;
                    }
                    catch (Exception e) {
                        Test1113512Test.this.getLog().warning("Received Exception from SBB or resource:");
                        Test1113512Test.this.getLog().warning(e);
                        Test1113512Test.this.result.setError(e);
                    }
                }
                return;
            }
            Test1113512Test.this.getLog().info("Notification received: " + notification);
        }
    }
}

