/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.profilefacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class ProfileFacilityTest
extends AbstractSleeTCKTest {
    private static final String PROFILE_TABLE_NAME = "ProfileFacilityTestTable";
    private static final String PROFILE_SPEC_NAME = "ProfileFacilityTestProfile";
    private static final String PROFILE_NAME = "testProfile";
    private static final String PROFILE_SPEC_DU_PATH_PARAM = "profileDUPath";
    private static final String PROFILE_TABLE_NAME_2 = "ProfileFacilityTestTable2";
    private static final String PROFILE_NAME_2 = "testProfile2";
    private static final String PROFILE_TABLE_NAME_3 = "ProfileFacilityTestTable3";
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private String testName;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioningMBean;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        String activityName = "ProfileFacilityTest";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.testName = this.utils().getTestParams().getProperty("testName");
        this.profileUtils = new ProfileUtils(this.utils());
        String profileDUPath = this.utils().getTestParams().getProperty(PROFILE_SPEC_DU_PATH_PARAM);
        if (profileDUPath != null) {
            this.getLog().info("installing profile specification");
            this.utils().install(profileDUPath);
            this.profileProvisioningMBean = this.profileUtils.getProfileProvisioningProxy();
            ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
            this.getLog().info("creating profile table ProfileFacilityTestTable");
            this.profileProvisioningMBean.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
            this.getLog().info("creating profile ProfileFacilityTestTable/testProfile");
            ObjectName profile = this.profileProvisioningMBean.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
            ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
            profProxy.closeProfile();
            this.getLog().info("creating profile table ProfileFacilityTestTable2");
            this.profileProvisioningMBean.createProfileTable(profileSpecID, PROFILE_TABLE_NAME_2);
            this.getLog().info("creating profile ProfileFacilityTestTable2/testProfile");
            profile = this.profileProvisioningMBean.createProfile(PROFILE_TABLE_NAME_2, PROFILE_NAME);
            profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
            profProxy.closeProfile();
            this.getLog().info("creating profile ProfileFacilityTestTable2/testProfile2");
            profile = this.profileProvisioningMBean.createProfile(PROFILE_TABLE_NAME_2, PROFILE_NAME_2);
            profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
            profProxy.closeProfile();
            this.getLog().info("creating profile table ProfileFacilityTestTable3");
            this.profileProvisioningMBean.createProfileTable(profileSpecID, PROFILE_TABLE_NAME_3);
        }
        this.setupService("serviceDUPath", true);
    }

    public void tearDown() throws Exception {
        String profileDUPath = this.utils().getTestParams().getProperty(PROFILE_SPEC_DU_PATH_PARAM);
        if (profileDUPath != null && this.profileProvisioningMBean != null) {
            this.getLog().info("removing profile ProfileFacilityTestTable/testProfile");
            this.profileProvisioningMBean.removeProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
            this.getLog().info("removing profile table ProfileFacilityTestTable");
            this.profileProvisioningMBean.removeProfileTable(PROFILE_TABLE_NAME);
            this.getLog().info("removing profile ProfileFacilityTestTable2/testProfile2");
            this.profileProvisioningMBean.removeProfile(PROFILE_TABLE_NAME_2, PROFILE_NAME_2);
            this.getLog().info("removing profile ProfileFacilityTestTable2/testProfile");
            this.profileProvisioningMBean.removeProfile(PROFILE_TABLE_NAME_2, PROFILE_NAME);
            this.getLog().info("removing profile table ProfileFacilityTestTable2");
            this.profileProvisioningMBean.removeProfileTable(PROFILE_TABLE_NAME_2);
            this.getLog().info("removing profile table ProfileFacilityTestTable3");
            this.profileProvisioningMBean.removeProfileTable(PROFILE_TABLE_NAME_3);
        }
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = (String)sbbData.get("testname");
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            ProfileFacilityTest.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                if (sbbTestName.equals(ProfileFacilityTest.this.testName)) {
                    Assert.assertEquals(assertionID, "Test " + ProfileFacilityTest.this.testName + " failed: " + sbbTestMessage, "pass", sbbTestResult);
                    ProfileFacilityTest.this.result.setPassed();
                } else {
                    ProfileFacilityTest.this.result.setError("Invalid response sent by SBB: " + sbbTestName);
                }
            }
            catch (TCKTestFailureException ex) {
                ProfileFacilityTest.this.result.setFailed(ex);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            ProfileFacilityTest.this.getLog().warning("Received Exception from SBB or resource:");
            ProfileFacilityTest.this.getLog().warning(exception);
            ProfileFacilityTest.this.result.setError(exception);
        }
    }
}

