/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.timerfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.InitialEventSelector;
import javax.slee.SbbContext;
import javax.slee.facilities.Level;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;

public abstract class TimerEventSbb
extends BaseTCKSbb {
    private TimerFacility timerFacility;
    private boolean result = false;
    private String message;
    private int failedAssertionID = -1;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)myEnv.lookup("slee/facilities/timer");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received start message", null);
            this.setTestName((String)event.getMessage());
            TimerID id = null;
            long startTime = System.currentTimeMillis() + 5000L;
            this.setStartTime(startTime);
            long period = 2000L;
            int numRepetitions = 2;
            TimerOptions options = new TimerOptions();
            options.setPreserveMissed(TimerPreserveMissed.ALL);
            if (this.getTestName().equals("timerEvent-single")) {
                id = this.timerFacility.setTimer(aci, null, startTime, options);
            } else if (this.getTestName().equals("timerEvent-periodic-finite")) {
                id = this.timerFacility.setTimer(aci, null, startTime, period, numRepetitions, options);
                this.setPeriod(period);
                this.setNumRepetitions(numRepetitions);
            } else if (this.getTestName().equals("timerEvent-periodic-infinite")) {
                id = this.timerFacility.setTimer(aci, null, startTime, period, 0, options);
                this.setPeriod(period);
                this.setNumRepetitions(0);
            }
            this.setTimerID(id);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received timer event", null);
            this.setNumTimerEvents(this.getNumTimerEvents() + 1);
            if (this.getTestName().equals("timerEvent-single")) {
                if (this.getStartTime() != event.getScheduledTime()) {
                    this.setResultFailed(1240, "non-periodic timer: timerEvent.getScheduledTime() != setTimer() startTime");
                } else if (event.getPeriod() != Long.MAX_VALUE) {
                    this.setResultFailed(1243, "non-periodic timer: timerEvent.getPeriod() != Long.MAX_VALUE");
                } else if (event.getNumRepetitions() != 1) {
                    this.setResultFailed(1244, "non-periodic timer: timerEvent.getNumRepetitions() != 1");
                } else if (event.getRemainingRepetitions() != 0) {
                    this.setResultFailed(1245, "non-periodic timer: timerEvent.getRemainingRepetitions() != 0");
                } else {
                    this.setResultPassed("non-periodic TimerEvent tests passed");
                }
                this.sendResultToTCK();
            } else if (this.getTestName().equals("timerEvent-periodic-finite")) {
                boolean failed = false;
                if (this.getNumTimerEvents() == 1) {
                    if (this.getStartTime() != event.getScheduledTime()) {
                        this.setResultFailed(1240, "periodic timer: timerEvent.getScheduledTime() did not match setTimer() startTime");
                        failed = true;
                    }
                } else if (this.getNumTimerEvents() == 2) {
                    if (this.getStartTime() + this.getPeriod() != event.getScheduledTime()) {
                        this.setResultFailed(1241, "periodic timer: timerEvent.getScheduledTime() did not match setTimer() startTime + period");
                        failed = true;
                    }
                } else if (event.getPeriod() != this.getPeriod()) {
                    this.setResultFailed(1243, "periodic timer: timerEvent.getPeriod() != setTimer() period");
                    failed = true;
                } else if (event.getNumRepetitions() != this.getNumRepetitions()) {
                    this.setResultFailed(1244, "periodic timer: timerEvent.getNumRepetitions() != setTimer() numRepetitions");
                    failed = true;
                } else if (event.getRemainingRepetitions() != this.getNumRepetitions() - this.getNumTimerEvents()) {
                    this.setResultFailed(1245, "periodic timer: timerEvent.getRemainingRepetitions() incorrect");
                    failed = true;
                }
                if (failed) {
                    this.timerFacility.cancelTimer(this.getTimerID());
                    this.sendResultToTCK();
                } else if (this.getNumTimerEvents() == 2) {
                    this.setResultPassed("finite non-periodic timer TimerEvent tests passed");
                    this.sendResultToTCK();
                }
            } else if (this.getTestName().equals("timerEvent-periodic-infinite")) {
                boolean failed = false;
                if (this.getNumTimerEvents() == 1) {
                    if (this.getStartTime() != event.getScheduledTime()) {
                        this.setResultFailed(1240, "infinite periodic timer: timerEvent.getScheduledTime() did not match setTimer() startTime");
                        failed = true;
                    }
                } else if (this.getNumTimerEvents() == 2) {
                    if (this.getStartTime() + this.getPeriod() != event.getScheduledTime()) {
                        this.setResultFailed(1241, "infinite periodic timer: timerEvent.getScheduledTime() did not match setTimer() startTime + period");
                        failed = true;
                    }
                } else if (event.getPeriod() != this.getPeriod()) {
                    this.setResultFailed(1243, "infinite periodic timer: timerEvent.getPeriod() != setTimer() period");
                    failed = true;
                } else if (event.getNumRepetitions() != 0) {
                    this.setResultFailed(1244, "infinite periodic timer: timerEvent.getNumRepetitions() != 0");
                    failed = true;
                } else if (event.getRemainingRepetitions() != Integer.MAX_VALUE) {
                    this.setResultFailed(1245, "infinite periodic timer: timerEvent.getRemainingRepetitions() != Integer.MAX_VALUE");
                    failed = true;
                }
                if (failed) {
                    this.timerFacility.cancelTimer(this.getTimerID());
                    this.sendResultToTCK();
                } else if (this.getNumTimerEvents() == 2) {
                    this.timerFacility.cancelTimer(this.getTimerID());
                    this.setResultPassed("infinite non-periodic timer TimerEvent tests passed");
                    this.sendResultToTCK();
                }
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public InitialEventSelector getStaticConvergenceName(InitialEventSelector ies) {
        ies.setCustomName("foobar");
        return ies;
    }

    public abstract void setTestName(String var1);

    public abstract String getTestName();

    public abstract void setStartTime(long var1);

    public abstract long getStartTime();

    public abstract void setPeriod(long var1);

    public abstract long getPeriod();

    public abstract void setNumRepetitions(int var1);

    public abstract int getNumRepetitions();

    public abstract void setTimerID(TimerID var1);

    public abstract TimerID getTimerID();

    public abstract void setNumTimerEvents(int var1);

    public abstract int getNumTimerEvents();

    private void sendResultToTCK() throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", this.getTestName());
        sbbData.put("result", this.result ? "pass" : "fail");
        sbbData.put("message", this.message);
        sbbData.put("id", new Integer(this.failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void setResultFailed(int assertionID, String msg) throws Exception {
        this.result = false;
        this.failedAssertionID = assertionID;
        this.message = "Assertion " + assertionID + " failed: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, this.message, null);
    }

    private void setResultPassed(String msg) throws Exception {
        this.result = true;
        this.message = "Success: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, this.message, null);
    }
}

