/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.timerfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.facilities.Level;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;

public abstract class TimerFacilityTestSbb
extends BaseTCKSbb {
    private boolean result = false;
    private String message;
    private String testName;
    private int failedAssertionID;
    private static final String JNDI_TIMERFACILITY_NAME = "java:comp/env/slee/facilities/timer";

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.testName = (String)event.getMessage();
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received " + this.testName + " message", null);
            if (this.testName.equals("jndi")) {
                this.doJNDITest();
            } else if (this.testName.equals("exception")) {
                this.doExceptionTest(aci);
            } else if (this.testName.equals("timerID")) {
                this.doTimerIDTest(aci);
            }
            this.sendResultToTCK();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK() throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", this.testName);
        sbbData.put("result", this.result ? "pass" : "fail");
        sbbData.put("message", this.message);
        sbbData.put("id", new Integer(this.failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void setResultFailed(int assertionID, String msg) throws Exception {
        this.result = false;
        this.failedAssertionID = assertionID;
        this.message = "Assertion " + assertionID + " failed: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, this.message, null);
    }

    private void setResultPassed(String msg) throws Exception {
        this.result = true;
        this.message = "Success: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, this.message, null);
    }

    private void doJNDITest() throws Exception {
        TimerFacility tf = this.getTimerFacility();
        if (tf != null) {
            this.setResultPassed("Found TimerFacility object in JNDI at java:comp/env/slee/facilities/timer");
        } else {
            this.setResultFailed(1409, "Could not find TimerFacility object in JNDI at java:comp/env/slee/facilities/timer");
        }
    }

    private void doExceptionTest(ActivityContextInterface aci) throws Exception {
        TimerFacility tf = this.getTimerFacility();
        try {
            tf.setTimer(null, null, 0L, new TimerOptions());
            this.setResultFailed(1200, "setTimer with null activity did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1200, "setTimer with null activity threw unexpected exception: " + e);
            return;
        }
        try {
            tf.setTimer(aci, null, 0L, null);
            this.setResultFailed(1200, "setTimer with null timerOptions did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1200, "setTimer with null timerOptions threw unexpected exception: " + e);
            return;
        }
        try {
            tf.setTimer(aci, null, -1L, new TimerOptions());
            this.setResultFailed(1201, "setTimer with negative startTime did not throw IllegalArgumentException");
            return;
        }
        catch (IllegalArgumentException iae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected IllegalArgumentException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1201, "setTimer with negative startTime threw unexpected exception: " + e);
            return;
        }
        try {
            tf.setTimer(null, null, 0L, 120000L, 0, new TimerOptions());
            this.setResultFailed(1200, "setTimer with null activity did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1200, "setTimer with null activity threw unexpected exception: " + e);
            return;
        }
        try {
            tf.setTimer(aci, null, 0L, 120000L, 0, null);
            this.setResultFailed(1200, "setTimer with null timerOptions did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1200, "setTimer with null timerOptions threw unexpected exception: " + e);
            return;
        }
        try {
            tf.setTimer(aci, null, -1L, 120000L, 0, new TimerOptions());
            this.setResultFailed(1201, "setTimer with negative startTime did not throw IllegalArgumentException");
            return;
        }
        catch (IllegalArgumentException iae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected IllegalArgumentException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1201, "setTimer with negative startTime threw unexpected exception: " + e);
            return;
        }
        try {
            tf.setTimer(aci, null, 0L, 120000L, -1, new TimerOptions());
            this.setResultFailed(3557, "setTimer with negative numRepetitions did not throw IllegalArgumentException");
            return;
        }
        catch (IllegalArgumentException iae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected IllegalArgumentException", null);
        }
        catch (Exception e) {
            this.setResultFailed(3557, "setTimer with negative numRepetitions threw unexpected exception: " + e);
            return;
        }
        try {
            tf.setTimer(aci, null, 0L, -100L, 0, new TimerOptions());
            this.setResultFailed(1201, "setTimer with negative period did not throw IllegalArgumentException");
            return;
        }
        catch (IllegalArgumentException iae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected IllegalArgumentException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1201, "setTimer with negative period threw unexpected exception: " + e);
            return;
        }
        try {
            tf.setTimer(aci, null, 0L, 0L, 0, new TimerOptions());
            this.setResultFailed(1201, "setTimer with zero period did not throw IllegalArgumentException");
            return;
        }
        catch (IllegalArgumentException iae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected IllegalArgumentException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1201, "setTimer with zero period threw unexpected exception: " + e);
            return;
        }
        try {
            tf.setTimer(aci, null, 0L, 120000L, 0, new TimerOptions(false, 120001L, TimerPreserveMissed.NONE));
            this.setResultFailed(1201, "setTimer with options.timeout greater than period did not throw IllegalArgumentException");
            return;
        }
        catch (IllegalArgumentException iae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected IllegalArgumentException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1201, "setTimer with options.timeout greater than period threw unexpected exception: " + e);
            return;
        }
        try {
            tf.cancelTimer(null);
            this.setResultFailed(1205, "cancelTimer with null timerID did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1205, "cancelTimer with null timerID threw unexpected exception: " + e);
            return;
        }
        this.setResultPassed("TimerFacility exception tests passed");
    }

    private void doTimerIDTest(ActivityContextInterface aci) throws Exception {
        TimerID timerID;
        TimerFacility tf;
        block5: {
            tf = this.getTimerFacility();
            timerID = tf.setTimer(aci, null, 0L, new TimerOptions());
            if (timerID instanceof Serializable) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(timerID);
                    oos.close();
                    byte[] buf = baos.toByteArray();
                    ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    TimerID testID = (TimerID)ois.readObject();
                    ois.close();
                    if (testID.equals(timerID)) {
                        this.setResultPassed("TimerID implementation serializes/deserializes OK");
                        break block5;
                    }
                    this.setResultFailed(1175, "TimerID implementation did not deserialize OK");
                }
                catch (Exception e) {
                    this.setResultFailed(1175, "TimerID implementation is not serializable, got exception: " + e);
                }
            } else {
                this.setResultFailed(1175, "TimerID implementation is not serializable");
            }
        }
        tf.cancelTimer(timerID);
    }

    private TimerFacility getTimerFacility() throws Exception {
        TimerFacility tf = null;
        try {
            tf = (TimerFacility)new InitialContext().lookup(JNDI_TIMERFACILITY_NAME);
        }
        catch (Exception e) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, "got unexpected Exception: " + e, null);
        }
        return tf;
    }
}

