/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.timerfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventY;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.SbbContext;
import javax.slee.facilities.Level;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;

public abstract class TimerPreserveMissedSbb
extends BaseTCKSbb {
    private TimerFacility timerFacility;
    private boolean result = false;
    private String message;
    private int failedAssertionID = -1;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)myEnv.lookup("slee/facilities/timer");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received start message", null);
            this.setTestName((String)event.getMessage());
            TimerOptions preserveAll = new TimerOptions();
            preserveAll.setPreserveMissed(TimerPreserveMissed.ALL);
            TimerOptions preserveLast = new TimerOptions();
            preserveLast.setPreserveMissed(TimerPreserveMissed.LAST);
            if (this.getTestName().equals("TimerPreserveMissed-periodic-all")) {
                this.timerFacility.setTimer(aci, null, 0L, 1L, 5, preserveAll);
            } else if (this.getTestName().equals("TimerPreserveMissed-periodic-last")) {
                this.timerFacility.setTimer(aci, null, 0L, 1L, 5, preserveLast);
            } else if (this.getTestName().equals("TimerPreserveMissed-single-all")) {
                this.timerFacility.setTimer(aci, null, 0L, preserveAll);
            } else if (this.getTestName().equals("TimerPreserveMissed-single-last")) {
                this.timerFacility.setTimer(aci, null, 0L, preserveLast);
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventY1(TCKResourceEventY event, ActivityContextInterface aci) {
        try {
            if (this.getTestName().equals("TimerPreserveMissed-periodic-all")) {
                if (this.getNumTimerEvents() == 5) {
                    this.setResultPassed("periodic timer with ALL completed successfully");
                } else {
                    this.setResultFailed(1225, "periodic timer with ALL did not preserve all timer events.");
                }
            } else if (this.getTestName().equals("TimerPreserveMissed-periodic-last")) {
                if (this.getNumTimerEvents() >= 1 && this.getNumTimerEvents() <= 5) {
                    this.setResultPassed("periodic timer with LAST completed successfully");
                } else {
                    this.setResultFailed(1227, "periodic timer with LAST did not preserve at least one timer event.");
                }
            } else if (this.getTestName().equals("TimerPreserveMissed-single-all")) {
                if (this.getNumTimerEvents() == 1) {
                    this.setResultPassed("single timer with ALL completed successfully");
                } else {
                    this.setResultFailed(1225, "single timer with ALL missed timer event.");
                }
            } else if (this.getTestName().equals("TimerPreserveMissed-single-last")) {
                if (this.getNumTimerEvents() == 1) {
                    this.setResultPassed("single timer with LAST completed successfully");
                } else {
                    this.setResultFailed(1227, "single timer with LAST missed timer event.");
                }
            }
            this.sendResultToTCK();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received timer event", null);
            this.setNumTimerEvents(this.getNumTimerEvents() + 1);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public abstract void setTestName(String var1);

    public abstract String getTestName();

    public abstract void setNumTimerEvents(int var1);

    public abstract int getNumTimerEvents();

    private void sendResultToTCK() throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", this.getTestName());
        sbbData.put("result", this.result ? "pass" : "fail");
        sbbData.put("message", this.message);
        sbbData.put("id", new Integer(this.failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void setResultFailed(int assertionID, String msg) throws Exception {
        this.result = false;
        this.failedAssertionID = assertionID;
        this.message = "Assertion " + assertionID + " failed: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, this.message, null);
    }

    private void setResultPassed(String msg) throws Exception {
        this.result = true;
        this.message = "Success: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, this.message, null);
    }
}

