/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.EventContext;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.facilities.Tracer;

public abstract class Test1108126Sbb
extends BaseTCKSbb {
    public static final String TRACE_MESSAGE_TCKResourceEventX1 = "Test1108126Sbb:I got TCKResourceEventX1 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2 = "Test1108126Sbb:I got TCKResourceEventX2 on ActivityB";
    public static final String TRACE_MESSAGE_Test1108126Event = "Test1108126Sbb:I got Test1108126Event";
    public static int waitPeriodMs = 10000;
    private Tracer tracer = null;

    public InitialEventSelector initialEventSelector(InitialEventSelector ies) {
        ies.setCustomName("test");
        return ies;
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX1);
            this.setEventContext(context);
            context.suspendDelivery();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2);
            EventContext ec = this.getEventContext();
            if (!ec.isSuspended()) {
                this.sendResultToTCK("Test1108126Test", false, "ERROR: The event delivery hasn't been suspended, the EventContext.isSuspended() returned false!", 1108126);
                return;
            }
            if (ec == null) {
                this.sendResultToTCK("Test1108126Test", false, "ERROR: The EventContext object which was stored in CMPfield of an SBB did not match the original EventContext object was given via the first event handler method in the different transactions.", 1108126);
            } else {
                this.sendResultToTCK("Test1108126Test", true, "An EventContext object can be stored in CMP field of an SBB if the type of the CMP field is this interface.", 1108126);
            }
            try {
                if (ec.isSuspended()) {
                    ec.resumeDelivery();
                }
            }
            catch (Exception e) {
                this.tracer.severe("Failed to resume the suspended event delivery.");
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK(String testName, boolean result, String message, int failedAssertionID) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    public abstract void setEventContext(EventContext var1);

    public abstract EventContext getEventContext();
}

