/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.facilities.TimerFacility;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import java.util.HashMap;
import javax.slee.management.DeployableUnitID;

public class Test3549Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private SleeTCKTestUtils utils;
    private DeployableUnitID duID;
    private boolean rolledBack = true;
    private int timerSeen = 0;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        QueuingResourceListener listener = new QueuingResourceListener(this.utils);
        this.utils.getResourceInterface().setResourceListener(listener);
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test3549InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        Integer id = null;
        Object sbbMessage = null;
        while (true) {
            try {
                sbbMessage = listener.nextMessage().getMessage();
            }
            catch (OperationTimedOutException e) {
                break;
            }
            HashMap map = (HashMap)sbbMessage;
            if (map.get("Type").equals("TimerSeen")) {
                ++this.timerSeen;
                id = (Integer)map.get("ID");
            }
            if (!map.get("Type").equals("RolledBack")) continue;
            this.rolledBack = true;
        }
        if (this.timerSeen == 0 && this.rolledBack) {
            return TCKTestResult.passed();
        }
        if (!this.rolledBack) {
            return TCKTestResult.error("Was unable to setup the required event and rollback.");
        }
        return TCKTestResult.failed(id, "Expected timer event not to be fired, but it was fired " + this.timerSeen + " times.");
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

