/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.AlarmNotification;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.facilities.Level;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;

public class Test4085Test
implements SleeTCKTest,
NotificationListener {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 4085;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private SbbID sbbID;
    private AlarmNotification firstAlarm;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test4085InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 4085);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        AlarmMBeanProxy alarmMBeanProxy = this.utils.getMBeanProxyFactory().createAlarmMBeanProxy(this.utils.getSleeManagementMBeanProxy().getAlarmMBean());
        alarmMBeanProxy.addNotificationListener(this, null, null);
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof SbbID)) continue;
            this.utils.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        if (notification instanceof AlarmNotification) {
            AlarmNotification alarmNotification = (AlarmNotification)notification;
            if (this.firstAlarm == null) {
                this.firstAlarm = alarmNotification;
                return;
            }
            if (!alarmNotification.getAlarmType().equals("javax.slee.management.alarm")) {
                this.result.setFailed(4085, "AlarmNotification.getType() returned incorrect type.");
                return;
            }
            if (!alarmNotification.getAlarmSource().equals(this.sbbID)) {
                this.result.setFailed(4087, "AlarmNotification.getSource() returned incorrect source.");
                return;
            }
            if (!alarmNotification.getLevel().equals((Object)Level.INFO)) {
                this.result.setFailed(4089, "AlarmNotification.getLevel() returned incorrect level.");
                return;
            }
            if (alarmNotification.getCause() != null) {
                this.result.setFailed(4091, "AlarmNotification.getCause() returned a cause, it should have been null.");
                return;
            }
            try {
                alarmNotification.hashCode();
            }
            catch (Exception e) {
                this.result.setFailed(4095, "AlarmNotification.hashCode() threw an exception.");
                return;
            }
            try {
                alarmNotification.toString();
            }
            catch (Exception e) {
                this.result.setFailed(4097, "AlarmNotification.toString() threw an exception.");
                return;
            }
            if (alarmNotification.toString() == null) {
                this.result.setFailed(4097, "AlarmNotification.toString() returned null.");
                return;
            }
            if (this.firstAlarm.equals((Object)alarmNotification)) {
                this.result.setFailed(4093, "AlarmNotification.equals(AlarmNotification) returned true for non-identical alarms.");
                return;
            }
            if (!alarmNotification.equals((Object)alarmNotification)) {
                this.result.setFailed(4093, "AlarmNotification.equals(AlarmNotification) returned false when comparing an alarm with itself.");
                return;
            }
            this.result.setPassed();
            return;
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            Test4085Test.this.utils.getLog().info("Received message from SBB.");
            if (passed.booleanValue()) {
                Test4085Test.this.result.setPassed();
            } else {
                Test4085Test.this.result.setFailed(4085, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test4085Test.this.utils.getLog().warning("Received exception from SBB");
            Test4085Test.this.utils.getLog().warning(e);
            Test4085Test.this.result.setError(e);
        }
    }
}

