/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.DeploymentMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import javax.slee.ComponentID;
import javax.slee.EventTypeID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;

public class Test3776Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 3776;
    private SleeTCKTestUtils utils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitID[] initialDuIDs = duProxy.getDeployableUnits();
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        String duURL = this.utils.getDeploymentUnitURL(duPath);
        DeployableUnitID duID = duProxy.install(duURL);
        try {
            TCKTestResult e7;
            DeployableUnitID[] duIDsAfterInstall = duProxy.getDeployableUnits();
            if (duIDsAfterInstall.length != initialDuIDs.length + 1) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install the number was " + duIDsAfterInstall.length + " (was expecting an increase of 1)");
                return tCKTestResult;
            }
            this.logSuccessfulCheck(3776);
            SbbID[] sbbIDs = duProxy.getSbbs();
            if (sbbIDs.length != 1) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(3780, "DeploymentMBean.getSbbs() returned incorrect number of SBBs.");
                return duIDsAfterUninstall;
            }
            this.logSuccessfulCheck(3780);
            EventTypeID[] eventIDs = duProxy.getEventTypes();
            if (eventIDs.length == 0) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(3784, "DeploymentMBean.getEventTypes() returned incorrect number of event types.");
                return duIDsAfterUninstall;
            }
            this.logSuccessfulCheck(3784);
            ProfileSpecificationID[] profileIDs = duProxy.getProfileSpecifications();
            for (int i = 0; i < profileIDs.length; ++i) {
                if (profileIDs[i] instanceof ProfileSpecificationID) continue;
                TCKTestResult tCKTestResult = TCKTestResult.failed(3788, "DeploymentMBean.getProfileSpecifications() returned an array containing objects other than ProfileSpecificationID.");
                return tCKTestResult;
            }
            this.logSuccessfulCheck(3788);
            ServiceID[] serviceIDs = duProxy.getServices();
            if (serviceIDs.length != 1) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(3792, "DeploymentMBean.getServices() returned incorrect number of services.");
                return tCKTestResult;
            }
            this.logSuccessfulCheck(3792);
            try {
                duProxy.getResourceAdaptorTypes();
                this.logSuccessfulCheck(3796);
            }
            catch (Exception e2) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(3796, "DeploymentMBean.getResourceAdaptorTypes() threw an exception.");
                this.utils.getLog().fine("Deactivating and uninstalling service");
                duProxy.uninstall(duID);
                DeployableUnitID[] duIDsAfterUninstall2 = duProxy.getDeployableUnits();
                if (duIDsAfterUninstall2.length != initialDuIDs.length) {
                    return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall2.length);
                }
                this.logSuccessfulCheck(3776);
                return duIDsAfterUninstall;
            }
            try {
                duProxy.getResourceAdaptors();
                this.logSuccessfulCheck(4475);
            }
            catch (Exception e3) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(4475, "DeploymentMBean.getResourceAdaptors() threw an exception.");
                this.utils.getLog().fine("Deactivating and uninstalling service");
                duProxy.uninstall(duID);
                DeployableUnitID[] duIDsAfterUninstall3 = duProxy.getDeployableUnits();
                if (duIDsAfterUninstall3.length != initialDuIDs.length) {
                    return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall3.length);
                }
                this.logSuccessfulCheck(3776);
                return duIDsAfterUninstall;
            }
            boolean passed = false;
            try {
                duProxy.getReferringComponents(null);
            }
            catch (NullPointerException e4) {
                passed = true;
                this.logSuccessfulCheck(3802);
            }
            catch (Exception e5) {
                TCKTestResult duIDsAfterUninstall3 = TCKTestResult.failed(3802, "DeploymentMBean.getReferringComponents(null) didn't throw NullPointerException but " + e5.getClass().toString());
                this.utils.getLog().fine("Deactivating and uninstalling service");
                duProxy.uninstall(duID);
                DeployableUnitID[] duIDsAfterUninstall = duProxy.getDeployableUnits();
                if (duIDsAfterUninstall.length != initialDuIDs.length) {
                    return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall.length);
                }
                this.logSuccessfulCheck(3776);
                return duIDsAfterUninstall3;
            }
            if (!passed) {
                TCKTestResult e5 = TCKTestResult.failed(3802, "DeploymentMBean.getReferringComponents(null) didn't throw NullPointerException.");
                return e5;
            }
            passed = false;
            try {
                duProxy.getDescriptor((DeployableUnitID)null);
            }
            catch (NullPointerException e6) {
                passed = true;
                this.logSuccessfulCheck(3808);
            }
            catch (Exception e7) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(3808, "DeploymentMBean.getDescriptor((DeployableUnitID) null) didn't throw NullPointerException but " + e7.getClass().toString());
                this.utils.getLog().fine("Deactivating and uninstalling service");
                duProxy.uninstall(duID);
                DeployableUnitID[] duIDsAfterUninstall4 = duProxy.getDeployableUnits();
                if (duIDsAfterUninstall4.length != initialDuIDs.length) {
                    return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall4.length);
                }
                this.logSuccessfulCheck(3776);
                return duIDsAfterUninstall;
            }
            if (!passed) {
                e7 = TCKTestResult.failed(3808, "DeploymentMBean.getDescriptor((DeployableUnitID) null) didn't throw NullPointerException.");
                return e7;
            }
            passed = false;
            try {
                duProxy.getDescriptors((DeployableUnitID[])null);
            }
            catch (NullPointerException e8) {
                passed = true;
                this.logSuccessfulCheck(3814);
            }
            catch (Exception e9) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(3814, "DeploymentMBean.getDescriptors((DeployableUnitID[]) null) didn't throw NullPointerException but " + e9.getClass().toString());
                this.utils.getLog().fine("Deactivating and uninstalling service");
                duProxy.uninstall(duID);
                DeployableUnitID[] duIDsAfterUninstall5 = duProxy.getDeployableUnits();
                if (duIDsAfterUninstall5.length != initialDuIDs.length) {
                    return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall5.length);
                }
                this.logSuccessfulCheck(3776);
                return duIDsAfterUninstall;
            }
            if (!passed) {
                e7 = TCKTestResult.failed(3814, "DeploymentMBean.getDescriptors((DeployableUnitID[]) null) didn't throw NullPointerException.");
                return e7;
            }
            passed = false;
            try {
                duProxy.getDescriptor((ComponentID)null);
            }
            catch (NullPointerException e10) {
                passed = true;
                this.logSuccessfulCheck(3819);
            }
            catch (Exception e11) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(3819, "DeploymentMBean.getDescriptor((ComponentID) null) didn't throw NullPointerException but " + e11.getClass().toString());
                this.utils.getLog().fine("Deactivating and uninstalling service");
                duProxy.uninstall(duID);
                DeployableUnitID[] duIDsAfterUninstall6 = duProxy.getDeployableUnits();
                if (duIDsAfterUninstall6.length != initialDuIDs.length) {
                    return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall6.length);
                }
                this.logSuccessfulCheck(3776);
                return duIDsAfterUninstall;
            }
            if (!passed) {
                e7 = TCKTestResult.failed(3819, "DeploymentMBean.getDescriptor((ComponentID) null) didn't throw NullPointerException.");
                return e7;
            }
            passed = false;
            try {
                duProxy.getDescriptors((ComponentID[])null);
            }
            catch (NullPointerException e12) {
                passed = true;
                this.logSuccessfulCheck(3825);
            }
            catch (Exception e13) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(3825, "DeploymentMBean.getDescriptors((ComponentID[]) null) didn't throw NullPointerException but " + e13.getClass().toString());
                this.utils.getLog().fine("Deactivating and uninstalling service");
                duProxy.uninstall(duID);
                DeployableUnitID[] duIDsAfterUninstall7 = duProxy.getDeployableUnits();
                if (duIDsAfterUninstall7.length != initialDuIDs.length) {
                    return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall7.length);
                }
                this.logSuccessfulCheck(3776);
                return duIDsAfterUninstall;
            }
            if (!passed) {
                e7 = TCKTestResult.failed(3825, "DeploymentMBean.getDescriptors((ComponentID[]) null) didn't throw NullPointerException.");
                return e7;
            }
            passed = false;
            try {
                duProxy.isInstalled((DeployableUnitID)null);
            }
            catch (NullPointerException e14) {
                passed = true;
                this.logSuccessfulCheck(3829);
            }
            catch (Exception e15) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(3829, "DeploymentMBean.isInstalled((DeployableUnitID) null) threw " + e15.getClass().toString());
                this.utils.getLog().fine("Deactivating and uninstalling service");
                duProxy.uninstall(duID);
                DeployableUnitID[] duIDsAfterUninstall8 = duProxy.getDeployableUnits();
                if (duIDsAfterUninstall8.length != initialDuIDs.length) {
                    return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall8.length);
                }
                this.logSuccessfulCheck(3776);
                return duIDsAfterUninstall;
            }
            if (!passed) {
                e7 = TCKTestResult.failed(3829, "DeploymentMBean.isInstalled((DeployableUnitID) null) didn't throw NullPointerException.");
                return e7;
            }
            passed = false;
            try {
                duProxy.isInstalled((ComponentID)null);
            }
            catch (NullPointerException e16) {
                passed = true;
                this.logSuccessfulCheck(3833);
            }
            catch (Exception e17) {
                TCKTestResult duIDsAfterUninstall = TCKTestResult.failed(3833, "DeploymentMBean.isInstalled((ComponentID) null) threw " + e17.getClass().toString());
                this.utils.getLog().fine("Deactivating and uninstalling service");
                duProxy.uninstall(duID);
                DeployableUnitID[] duIDsAfterUninstall9 = duProxy.getDeployableUnits();
                if (duIDsAfterUninstall9.length != initialDuIDs.length) {
                    return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall9.length);
                }
                this.logSuccessfulCheck(3776);
                return duIDsAfterUninstall;
            }
            if (!passed) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(3833, "DeploymentMBean.isInstalled((ComponentID) null) didn't throw NullPointerException.");
                return tCKTestResult;
            }
        }
        finally {
            this.utils.getLog().fine("Deactivating and uninstalling service");
            duProxy.uninstall(duID);
            DeployableUnitID[] duIDsAfterUninstall = duProxy.getDeployableUnits();
            if (duIDsAfterUninstall.length != initialDuIDs.length) {
                return TCKTestResult.failed(3776, "DeploymentMBean.getDeployableUnits() returned incorrect number of deployable units. Before the installation of the service the number was " + initialDuIDs.length + ", and following the " + "install, then later uninstall of service, the number was " + duIDsAfterUninstall.length);
            }
            this.logSuccessfulCheck(3776);
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils.getLog().info("Check for assertion " + assertionID + " OK");
    }
}

