/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.EventTypeDescriptor;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import javax.slee.ComponentID;
import javax.slee.EventTypeID;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.EventTypeDescriptor;

public class Test3835Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 3835;
    private SleeTCKTestUtils utils;
    private DeployableUnitID duID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        EventTypeID[] eventIDs = duProxy.getEventTypes();
        if (eventIDs.length == 0) {
            return TCKTestResult.error("No installed event types.");
        }
        EventTypeDescriptor evDesc = (EventTypeDescriptor)duProxy.getDescriptor((ComponentID)eventIDs[0]);
        try {
            evDesc.getEventClassName();
        }
        catch (Exception e) {
            return TCKTestResult.failed(3835, "EventTypeDescriptor.getEventClassName() threw an exception");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

