/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.ServiceUsageMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;

public class Test3980Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private SleeTCKTestUtils utils;
    private DeployableUnitID duID;
    private ServiceID serviceID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ServiceManagementMBeanProxy serviceProxy = this.utils.getMBeanProxyFactory().createServiceManagementMBeanProxy(this.utils.getSleeManagementMBeanProxy().getServiceManagementMBean());
        ObjectName usageMBeanName = serviceProxy.getServiceUsageMBean(this.serviceID);
        if (!this.utils.getMBeanFacade().isRegistered(usageMBeanName)) {
            return TCKTestResult.failed(1430, "ServiceManagementMBean.getServiceUsageMBean() returned the ObjectName of an MBean which was not registered with the MBeanServer");
        }
        ServiceUsageMBeanProxy serviceUsageMBean = this.utils.getMBeanProxyFactory().createServiceUsageMBeanProxy(usageMBeanName);
        if (!serviceUsageMBean.getService().equals((Object)this.serviceID)) {
            return TCKTestResult.failed(3980, "ServiceUsageMBean.getService() returned an incorrect ServiceID object.");
        }
        try {
            serviceUsageMBean.close();
        }
        catch (Exception e) {
            return TCKTestResult.failed(4009, "ServiceUsageMBean.close() threw an exception.");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            this.utils.getLog().fine("Setting serviceID value.");
            this.serviceID = (ServiceID)components[i];
        }
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

