/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.TraceMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.facilities.Level;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;

public class Test4055Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private SleeTCKTestUtils utils;
    private DeployableUnitID duID;
    private SbbID sbbID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        TraceMBeanProxy traceMBean = this.utils.getMBeanProxyFactory().createTraceMBeanProxy(this.utils.getSleeManagementMBeanProxy().getTraceMBean());
        traceMBean.setTraceLevel((ComponentID)this.sbbID, Level.FINE);
        if (traceMBean.getTraceLevel((ComponentID)this.sbbID) != Level.FINE) {
            return TCKTestResult.failed(4062, "TraceMBean.set/getLevel() didn't work as specified.");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof SbbID)) continue;
            this.utils.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

