/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.ProfileContext;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEvent;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEventImpl;
import com.opencloud.sleetck.lib.testsuite.javax.slee.profile.ProfileContext.ProfileContextTestsProfileLocal;
import javax.naming.Context;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.RolledBackContext;
import javax.slee.SbbContext;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileTable;

public abstract class Test1110346Sbb
extends BaseTCKSbb {
    public static int MODE_BUSINESS = 1;
    public static int MODE_BUSINESS_ROLLBACK = 2;
    public static final String PROFILE_TABLE_NAME = "Test1110346ProfileTable";
    public static final String PROFILE_NAME = "Test1110346Profile";
    public static final int BUSINESS = 1;
    public static final int BUSINESS_ROLLBACK = 2;
    public static final int SET_BUSINESS = 3;
    public static final int SET_BUSINESS_ROLLBACK = 4;
    private RMIObjectChannel out;
    private BaseMessageSender msgSender;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            context.getTracer(this.getSbbID().getName()).warning("An error occured creating an RMIObjectChannel:", (Throwable)e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            int operationID = (Integer)event.getMessage();
            switch (operationID) {
                case 4: {
                    this.setMode(MODE_BUSINESS_ROLLBACK);
                    this.fireTCKSbbEvent(new TCKSbbEventImpl("Set mode to BUSINESS_ROLLBACK"), aci, null);
                    break;
                }
                case 3: {
                    this.setMode(MODE_BUSINESS);
                    this.fireTCKSbbEvent(new TCKSbbEventImpl("Set mode to BUSINESS"), aci, null);
                    break;
                }
                case 1: {
                    Context env = TCKSbbUtils.getSbbEnvironment();
                    ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
                    this.msgSender.sendLogMsg("Obtained profileFacility object.");
                    ProfileTable profileTable = profileFacility.getProfileTable(PROFILE_TABLE_NAME);
                    this.msgSender.sendLogMsg("Obtained profileTable object.");
                    ProfileContextTestsProfileLocal profileLocal = (ProfileContextTestsProfileLocal)profileTable.find(PROFILE_NAME);
                    this.msgSender.sendLogMsg("Obtained profileLocal object.");
                    profileLocal.business();
                    this.fireTCKSbbEvent(new TCKSbbEventImpl("Business method executed without rollback."), aci, null);
                    break;
                }
                case 2: {
                    Context env = TCKSbbUtils.getSbbEnvironment();
                    ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
                    this.msgSender.sendLogMsg("Obtained profileFacility object.");
                    ProfileTable profileTable = profileFacility.getProfileTable(PROFILE_TABLE_NAME);
                    this.msgSender.sendLogMsg("Obtained profileTable object.");
                    ProfileContextTestsProfileLocal profileLocal = (ProfileContextTestsProfileLocal)profileTable.find(PROFILE_NAME);
                    this.msgSender.sendLogMsg("Obtained profileLocal object.");
                    this.getSbbContext().setRollbackOnly();
                    profileLocal.getRollbackTest();
                }
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
        }
    }

    public void onTCKSbbEvent(TCKSbbEvent event, ActivityContextInterface aci) {
        try {
            this.msgSender.sendSuccess(1110346, (String)event.getMessage());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
        if (this.getMode() == MODE_BUSINESS) {
            this.msgSender.sendFailure(1110346, "Business method should have completed without exception.");
        } else if (this.getMode() == MODE_BUSINESS_ROLLBACK) {
            this.msgSender.sendSuccess(1110346, "Transaction rolled back as expected.");
        }
    }

    public abstract void fireTCKSbbEvent(TCKSbbEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void setMode(int var1);

    public abstract int getMode();
}

