/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.ProfileFacility;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;

public class Test4459Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 4459;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test4459InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 4459);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
        ProfileProvisioningMBeanProxy profileProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            profileProxy.createProfileTable(profileSpecID, "Test4459ProfileTable");
            ObjectName profile = profileProxy.createProfile("Test4459ProfileTable", "Test4459Profile");
            ProfileMBeanProxy profileMBeanProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profile);
            try {
                this.utils.getMBeanFacade().setAttribute(profile, new Attribute("IntVal", new Integer(42)));
                break;
            }
            finally {
                if (profileMBeanProxy.isProfileWriteable()) {
                    profileMBeanProxy.commitProfile();
                }
                profileMBeanProxy.closeProfile();
            }
        }
    }

    public void tearDown() throws Exception {
        ProfileProvisioningMBeanProxy profileProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        try {
            profileProxy.removeProfile("Test4459ProfileTable", "Test4459Profile");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            profileProxy.removeProfileTable("Test4459ProfileTable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            String type = (String)map.get("Type");
            if (type.equals("ProfileID")) {
                ProfileID profileID = (ProfileID)map.get("ProfileID");
                if (profileID.getProfileTableName().equals("Test4459ProfileTable") && profileID.getProfileName().equals("Test4459Profile")) {
                    Test4459Test.this.result.setPassed();
                } else {
                    Test4459Test.this.result.setFailed(4459, "Profile Table's default table returned from ProfileFacility.getProfileByIndexedAttribute.");
                }
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test4459Test.this.utils.getLog().warning("Received exception from SBB");
            Test4459Test.this.utils.getLog().warning(e);
            Test4459Test.this.result.setError(e);
        }
    }
}

