/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.ProfileRemovedEvent;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;

public class Test4386Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 4386;
    private ProfileProvisioningMBeanProxy profileProxy;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileID profileID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test4386InitialActivity");
        this.utils.getLog().fine("Firing initial event on SBB.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 4386);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
        this.profileProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            this.utils.getLog().fine("Creating profile and profile table.");
            this.profileProxy.createProfileTable(profileSpecID, "Test4386ProfileTable");
            ObjectName profile = this.profileProxy.createProfile("Test4386ProfileTable", "Test4386Profile");
            ProfileMBeanProxy profProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
            profProxy.closeProfile();
        }
        this.utils.getLog().fine("Created profile table and profile.");
    }

    public void tearDown() throws Exception {
        if (this.profileProxy != null) {
            try {
                this.profileProxy.removeProfile("Test4386ProfileTable", "Test4386Profile");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.profileProxy.removeProfileTable("Test4386ProfileTable");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            try {
                ProfileProvisioningMBeanProxy profileProxy = new ProfileUtils(Test4386Test.this.utils).getProfileProvisioningProxy();
                HashMap map = (HashMap)message.getMessage();
                Boolean passed = (Boolean)map.get("Result");
                String msgString = (String)map.get("Message");
                Test4386Test.this.utils.getLog().info("Received message from SBB.");
                if (map.get("Type").equals("Result")) {
                    if (passed.booleanValue()) {
                        if (Test4386Test.this.profileID.getProfileTableName().equals("Test4386ProfileTable") && Test4386Test.this.profileID.getProfileName().equals("Test4386Profile")) {
                            Test4386Test.this.result.setPassed();
                        } else {
                            Test4386Test.this.result.setFailed(4389, "ProfileID object retrieved via ProfileRemovedEvent.getProfile() was not the modified profile.");
                        }
                    } else {
                        Test4386Test.this.result.setFailed((Integer)map.get("ID"), msgString);
                    }
                    return;
                }
                if (map.get("Type").equals("RemoveProfile")) {
                    profileProxy.removeProfile("Test4386ProfileTable", "Test4386Profile");
                    return;
                }
                if (map.get("Type").equals("ProfileID")) {
                    Test4386Test.this.profileID = (ProfileID)map.get("ProfileID");
                    return;
                }
            }
            catch (Exception e) {
                Test4386Test.this.result.setError(e);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test4386Test.this.utils.getLog().warning("Received exception from SBB");
            Test4386Test.this.utils.getLog().warning(e);
            Test4386Test.this.result.setError(e);
        }
    }
}

