/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.ProfileTableActivityContextInterfaceFactory;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEvent;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110040Test
extends AbstractSleeTCKTest {
    private static final String PROFILE_TABLE_NAME = "Test1110040ProfileTable";
    private static final String PROFILE_NAME = "Test1110040Profile";
    private static final String TCK_SBB_EVENT_DU_PATH_PARAM = "eventDUPath";
    private QueuingResourceListener resourceListener;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public TCKTestResult run() throws Exception {
        this.getLog().fine("Creating profile tables");
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile11", "jain.slee.tck", "1.1");
        this.profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.getLog().fine("Adding profile Test1110040Profile to the profile table");
        ObjectName profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        profProxy.commitProfile();
        try {
            TCKSbbMessage reply = this.resourceListener.nextMessage();
            if (!TCKSbbEvent.class.getName().equals(reply.getMessage())) {
                return TCKTestResult.error("Received unexpected reply from SBB. Message=" + reply.getMessage());
            }
        }
        catch (OperationTimedOutException ex) {
            return TCKTestResult.failed(new TCKTestFailureException(1110040, "Timed out waiting for acknowledgement of obtaining a  ProfileTableActivityContextInterfaceFactory object via environment lookup.", ex));
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.setupService("profileSpecDUPath");
        this.setupService(TCK_SBB_EVENT_DU_PATH_PARAM);
        this.setupService("serviceDUPath");
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.profileProvisioning = new ProfileUtils(this.utils()).getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        try {
            this.profileProvisioning.removeProfileTable(PROFILE_TABLE_NAME);
        }
        catch (Exception e) {
            this.getLog().warning("Exception occured when trying to remove profile table: ");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

