/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.usage.SampleStatistics;

import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanProxy;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageTest;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import java.math.BigDecimal;
import javax.management.Notification;
import javax.slee.usage.SampleStatistics;

public class SampleStatisticsTest
extends GenericUsageTest {
    private TCKActivityID activityID;
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListener;
    private GenericUsageMBeanProxy sbbUsageMBeanProxy;
    private long expectedMinimum;
    private long expectedMaximum;
    private long expectedSampleCount;
    private BigDecimal accumulatedSamplesSum;
    private StringBuffer sampleSetBuffer;

    public TCKTestResult run() throws Exception {
        this.activityID = this.utils().getResourceInterface().createActivity("SampleStatisticsTest-Activity");
        this.clearExpectedSet();
        this.testSampleSet(new long[]{2L, 3L, 5L, 7L, 11L, -2L, -3L, -5L, -7L, -11L, -11L}, 0.5);
        this.testSampleSet(new long[]{Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, 1L, 0L, -1L, -9223372036854775807L, Long.MIN_VALUE}, 0.5);
        this.testSampleSet(new long[]{Long.MIN_VALUE, -9223372036854775807L, -1L, 0L, 1L, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE}, 0.5);
        this.getLog().info("All checks passed");
        return TCKTestResult.passed();
    }

    private void testSampleSet(long[] samples, double errorThresholdForMean) throws Exception {
        this.resetStatistics();
        this.auditStatistics(0.0);
        for (int i = 0; i < samples.length; ++i) {
            long sample = samples[i];
            this.doUpdateAndWait(sample);
            this.auditStatistics(errorThresholdForMean);
        }
    }

    private void resetStatistics() throws Exception {
        this.sbbUsageMBeanProxy.getTimeBetweenNewConnections(true);
        this.clearExpectedSet();
    }

    private void clearExpectedSet() {
        this.expectedMaximum = Long.MIN_VALUE;
        this.expectedMinimum = Long.MAX_VALUE;
        this.expectedSampleCount = 0L;
        this.accumulatedSamplesSum = null;
        this.sampleSetBuffer = new StringBuffer("<Empty set>");
    }

    private void doUpdateAndWait(long sampleValue) throws Exception {
        this.getLog().fine("Sending update instructions to the SBB via an event. New sample value: " + sampleValue);
        GenericUsageSbbInstructions instructions = new GenericUsageSbbInstructions(null);
        instructions.addTimeBetweenNewConnectionsSamples(sampleValue);
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructions.toExported(), this.activityID, null);
        this.getLog().fine("Waiting for a reply from the SBB");
        this.resourceListener.nextMessage();
        this.getLog().fine("Received reply from SBB. Waiting for notification of update");
        Notification usageNotification = this.notificationListener.nextNotification();
        this.getLog().fine("Received notification of update: " + usageNotification);
        this.expectedMaximum = Math.max(this.expectedMaximum, sampleValue);
        this.expectedMinimum = Math.min(this.expectedMinimum, sampleValue);
        BigDecimal sampleBigDecimal = new BigDecimal(Long.toString(sampleValue));
        if (this.expectedSampleCount++ == 0L) {
            this.accumulatedSamplesSum = sampleBigDecimal;
            this.sampleSetBuffer = new StringBuffer(sampleValue + "");
        } else {
            this.accumulatedSamplesSum = this.accumulatedSamplesSum.add(sampleBigDecimal);
            this.sampleSetBuffer.append("," + sampleValue);
        }
    }

    private void auditStatistics(double errorThresholdForMean) throws Exception {
        double expectedMean = this.expectedSampleCount == 0L ? 0.0 : this.accumulatedSamplesSum.divide(new BigDecimal(this.expectedSampleCount), 50, 4).doubleValue();
        this.getLog().info("Auditing statistics. Expected values: expectedSampleCount=" + this.expectedSampleCount + ";expectedMinimum=" + this.expectedMinimum + ";expectedMaximum=" + this.expectedMaximum + ";expectedMean=" + expectedMean);
        SampleStatistics statistics = this.sbbUsageMBeanProxy.getTimeBetweenNewConnections(false);
        long sampleCountReturned = statistics.getSampleCount();
        if (sampleCountReturned != this.expectedSampleCount) {
            throw new TCKTestFailureException(4638, "SampleStatistics.getSampleCount() returned an invalid value. Expected=" + this.expectedSampleCount + "; sample count returned=" + sampleCountReturned + "; Sample set:{" + this.sampleSetBuffer + "}");
        }
        long minimumReturned = statistics.getMinimum();
        if (minimumReturned != this.expectedMinimum) {
            int violatedAssertion = this.expectedSampleCount == 0L ? 4642 : 4640;
            throw new TCKTestFailureException(violatedAssertion, "SampleStatistics.getMinimum() returned an invalid value. Expected=" + this.expectedMinimum + "; minimum value returned=" + minimumReturned + "; Sample set:{" + this.sampleSetBuffer + "}");
        }
        long maximumReturned = statistics.getMaximum();
        if (maximumReturned != this.expectedMaximum) {
            int violatedAssertion = this.expectedSampleCount == 0L ? 4645 : 4643;
            throw new TCKTestFailureException(violatedAssertion, "SampleStatistics.getMaximum() returned an invalid value. Expected=" + this.expectedMaximum + "; maximum value returned=" + maximumReturned + "; Sample set:{" + this.sampleSetBuffer + "}");
        }
        double meanReturned = statistics.getMean();
        if (meanReturned != expectedMean) {
            double differenceInMeans = Math.abs(expectedMean - meanReturned);
            if (differenceInMeans > errorThresholdForMean) {
                int violatedAssertion = this.expectedSampleCount == 0L ? 4648 : 4646;
                throw new TCKTestFailureException(violatedAssertion, "SampleStatistics.getMean() returned an invalid value. Expected=" + expectedMean + "; mean value returned=" + meanReturned + "; error threshold:" + errorThresholdForMean + "; Sample set:{" + this.sampleSetBuffer + "}");
            }
            this.getLog().warning("Tolerated difference between expected and returned mean of " + differenceInMeans + ". Expected=" + expectedMean + "; returned=" + meanReturned + "; Sample set:{" + this.sampleSetBuffer.toString() + "}");
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.sbbUsageMBeanProxy = this.getGenericUsageMBeanLookup().getUnnamedGenericUsageMBeanProxy();
        this.notificationListener = new QueuingNotificationListener(this.utils());
        this.sbbUsageMBeanProxy.addNotificationListener(this.notificationListener, null, null);
    }

    public void tearDown() throws Exception {
        if (this.notificationListener != null) {
            try {
                this.sbbUsageMBeanProxy.removeNotificationListener(this.notificationListener);
            }
            catch (Exception e) {
                this.getLog().warning(e);
            }
        }
        this.sbbUsageMBeanProxy = null;
        super.tearDown();
    }
}

