/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.usage.UsageNotification;

import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanLookup;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageTest;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import javax.slee.usage.UsageNotification;

public class Test4203Test
extends GenericUsageTest {
    private static final String FOO_SET_NAME = "FooSet";
    private GenericUsageMBeanLookup mBeanLookup;
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListenerFoo;
    private QueuingNotificationListener notificationListenerUnnamed;

    public TCKTestResult run() throws Exception {
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("Test4203InitialActivity");
        GenericUsageSbbInstructions instructionsForFoo = new GenericUsageSbbInstructions(FOO_SET_NAME);
        instructionsForFoo.addFirstCountIncrement(1L);
        instructionsForFoo.addFirstCountIncrement(1L);
        instructionsForFoo.addTimeBetweenNewConnectionsSamples(2L);
        this.getLog().info("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructionsForFoo.toExported(), activityID, null);
        GenericUsageSbbInstructions instructionsForUnnamed = new GenericUsageSbbInstructions(null);
        instructionsForUnnamed.addFirstCountIncrement(4L);
        instructionsForUnnamed.addTimeBetweenNewConnectionsSamples(5L);
        this.getLog().info("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructionsForUnnamed.toExported(), activityID, null);
        this.getLog().info("waiting for replies");
        this.resourceListener.nextMessage();
        this.resourceListener.nextMessage();
        this.getLog().info("received replies");
        this.getLog().info("waiting for usage notifications");
        UsageNotification firstCountFooA = (UsageNotification)this.notificationListenerFoo.nextNotification();
        UsageNotification firstCountFooB = (UsageNotification)this.notificationListenerFoo.nextNotification();
        UsageNotification timeBetweenNewConnectionsFoo = (UsageNotification)this.notificationListenerFoo.nextNotification();
        UsageNotification firstCountUnnamed = (UsageNotification)this.notificationListenerUnnamed.nextNotification();
        UsageNotification timeBetweenNewConnectionsUnnamed = (UsageNotification)this.notificationListenerUnnamed.nextNotification();
        this.getLog().info("auditing usage notifications");
        this.auditNotification(firstCountFooA, FOO_SET_NAME, "firstCount", true, 1L);
        this.auditNotification(firstCountFooB, FOO_SET_NAME, "firstCount", true, 2L);
        this.auditNotification(timeBetweenNewConnectionsFoo, FOO_SET_NAME, "timeBetweenNewConnections", false, 2L);
        this.auditNotification(firstCountUnnamed, null, "firstCount", true, 4L);
        this.auditNotification(timeBetweenNewConnectionsUnnamed, null, "timeBetweenNewConnections", false, 5L);
        if (!firstCountFooA.equals((Object)firstCountFooB)) {
            return TCKTestResult.failed(4211, "UsageNotification.equals() returned false for notifications with the same Service identifier, SBB identifier, usage parameter set name, and usage parameter name attributes");
        }
        if (firstCountFooA.equals((Object)timeBetweenNewConnectionsFoo)) {
            return TCKTestResult.failed(4211, "UsageNotification.equals() returned true for notifications with different parameter names");
        }
        if (firstCountFooA.equals((Object)firstCountUnnamed)) {
            return TCKTestResult.failed(4211, "UsageNotification.equals() returned true for notifications with different parameter set names");
        }
        if (firstCountFooA.equals((Object)timeBetweenNewConnectionsUnnamed)) {
            return TCKTestResult.failed(4211, "UsageNotification.equals() returned true for notifications with different parameter set names and different parameter names");
        }
        this.getLog().info("received and checked all " + (instructionsForFoo.getTotalUpdates() + instructionsForUnnamed.getTotalUpdates()) + " usage notifications");
        return TCKTestResult.passed();
    }

    private void auditNotification(UsageNotification usageNotification, String parameterSetName, String parameterName, boolean isCounter, long value) throws TCKTestFailureException {
        this.getLog().info("Auditing notification: " + usageNotification);
        Assert.assertEquals(4199, "UsageNotification.getType() returned an invalid notification type", "javax.slee.management.usage", usageNotification.getType());
        Assert.assertEquals(4203, "UsageNotification.getService() returned unexpected ServiceID.", this.mBeanLookup.getServiceID(), usageNotification.getService());
        Assert.assertEquals(4205, "UsageNotification.getSbb() returned unexpected SbbID.", this.mBeanLookup.getSbbID(), usageNotification.getSbb());
        Assert.assertEquals(4207, "UsageNotification.getParameterName() returned incorrect parameter name.", parameterName, usageNotification.getUsageParameterName());
        Assert.assertTrue(4209, "UsageNotification.getValue() returned incorrect value. Expected=" + value + ", actual=" + usageNotification.getValue(), value == usageNotification.getValue());
        Assert.assertTrue(4211, "UsageNotification.equals(self) returned false. Notification: " + usageNotification, usageNotification.equals((Object)usageNotification));
        Assert.assertEquals(4628, "UsageNotification.getUsageParameterSetName() returned the incorrect parameter set name", parameterSetName, usageNotification.getUsageParameterSetName());
        Assert.assertTrue(4630, "UsageNotification.isCounter returned the incorrect value for the \"" + parameterName + "\" parameter. Expected value=" + isCounter + ", actual value=" + usageNotification.isCounter(), isCounter == usageNotification.isCounter());
        int usageNotificationHash = usageNotification.hashCode();
        int expectedHash = usageNotification.getUsageParameterName().hashCode();
        if (usageNotification.getUsageParameterSetName() != null) {
            expectedHash ^= usageNotification.getUsageParameterSetName().hashCode();
        }
        if (usageNotificationHash != expectedHash) {
            throw new TCKTestFailureException(4631, "UsageNotification.hashCode() returned an unexpected hash code. Expected=" + expectedHash + ",actual=" + usageNotificationHash + ". Hashcode should be the logical XOR of the hash codes " + "of the usage parameter set name (if any) and the usage parameter name.");
        }
        try {
            usageNotification.toString();
        }
        catch (Exception e) {
            throw new TCKTestFailureException(4215, "UsageNotification.toString() threw an exception.", e);
        }
        if (usageNotification.toString() == null) {
            throw new TCKTestFailureException(4215, "UsageNotification.toString() returned null.");
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.mBeanLookup = this.getGenericUsageMBeanLookup();
        this.mBeanLookup.getServiceUsageMBeanProxy().createUsageParameterSet(this.mBeanLookup.getSbbID(), FOO_SET_NAME);
        this.notificationListenerFoo = new QueuingNotificationListener(this.utils());
        this.notificationListenerUnnamed = new QueuingNotificationListener(this.utils());
        this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(FOO_SET_NAME).addNotificationListener(this.notificationListenerFoo, null, null);
        this.mBeanLookup.getUnnamedGenericUsageMBeanProxy().addNotificationListener(this.notificationListenerUnnamed, null, null);
    }

    public void tearDown() throws Exception {
        if (this.mBeanLookup != null) {
            if (this.notificationListenerFoo != null) {
                this.mBeanLookup.getNamedGenericSbbUsageMBeanProxy(FOO_SET_NAME).removeNotificationListener(this.notificationListenerFoo);
            }
            if (this.notificationListenerUnnamed != null) {
                this.mBeanLookup.getUnnamedGenericUsageMBeanProxy().removeNotificationListener(this.notificationListenerUnnamed);
            }
        }
        super.tearDown();
    }
}

